/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.BitronixTransactionSynchronizationRegistry;
import bitronix.tm.Configuration;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.journal.DiskJournal;
import bitronix.tm.journal.Journal;
import bitronix.tm.journal.NullJournal;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.resource.ResourceLoader;
import bitronix.tm.timer.TaskScheduler;
import bitronix.tm.twopc.executor.AsyncExecutor;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.SyncExecutor;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.DefaultExceptionAnalyzer;
import bitronix.tm.utils.ExceptionAnalyzer;
import bitronix.tm.utils.InitializationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransactionManagerServices {
    private static final Logger log = Logger.getLogger(TransactionManagerServices.class.toString());
    private static final Lock transactionManagerLock = new ReentrantLock();
    private static final AtomicReference<BitronixTransactionSynchronizationRegistry> transactionSynchronizationRegistryRef = new AtomicReference();
    private static final AtomicReference<Configuration> configurationRef = new AtomicReference();
    private static final AtomicReference<Journal> journalRef = new AtomicReference();
    private static final AtomicReference<TaskScheduler> taskSchedulerRef = new AtomicReference();
    private static final AtomicReference<ResourceLoader> resourceLoaderRef = new AtomicReference();
    private static final AtomicReference<Recoverer> recovererRef = new AtomicReference();
    private static final AtomicReference<Executor> executorRef = new AtomicReference();
    private static final AtomicReference<ExceptionAnalyzer> exceptionAnalyzerRef = new AtomicReference();
    private static volatile BitronixTransactionManager transactionManager;

    private TransactionManagerServices() {
    }

    public static BitronixTransactionManager getTransactionManager() {
        transactionManagerLock.lock();
        try {
            if (transactionManager == null) {
                transactionManager = new BitronixTransactionManager();
            }
            BitronixTransactionManager bitronixTransactionManager = transactionManager;
            return bitronixTransactionManager;
        }
        finally {
            transactionManagerLock.unlock();
        }
    }

    public static BitronixTransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        BitronixTransactionSynchronizationRegistry transactionSynchronizationRegistry = transactionSynchronizationRegistryRef.get();
        if (transactionSynchronizationRegistry == null && !transactionSynchronizationRegistryRef.compareAndSet(null, transactionSynchronizationRegistry = new BitronixTransactionSynchronizationRegistry())) {
            transactionSynchronizationRegistry = transactionSynchronizationRegistryRef.get();
        }
        return transactionSynchronizationRegistry;
    }

    public static Journal getJournal() {
        Journal journal = journalRef.get();
        if (journal == null) {
            String configuredJournal = TransactionManagerServices.getConfiguration().getJournal();
            if ("null".equals(configuredJournal) || null == configuredJournal) {
                journal = new NullJournal();
            } else if ("disk".equals(configuredJournal)) {
                journal = new DiskJournal();
            } else {
                try {
                    Class clazz = ClassLoaderUtils.loadClass(configuredJournal);
                    journal = (Journal)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new InitializationException("invalid journal implementation '" + configuredJournal + "'", ex);
                }
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("using journal " + configuredJournal);
            }
            if (!journalRef.compareAndSet(null, journal)) {
                journal = journalRef.get();
            }
        }
        return journal;
    }

    public static Configuration getConfiguration() {
        Configuration configuration = configurationRef.get();
        if (configuration == null && !configurationRef.compareAndSet(null, configuration = new Configuration())) {
            configuration = configurationRef.get();
        }
        return configuration;
    }

    public static TaskScheduler getTaskScheduler() {
        TaskScheduler taskScheduler = taskSchedulerRef.get();
        if (taskScheduler == null) {
            taskScheduler = new TaskScheduler();
            if (!taskSchedulerRef.compareAndSet(null, taskScheduler)) {
                taskScheduler = taskSchedulerRef.get();
            } else {
                taskScheduler.start();
            }
        }
        return taskScheduler;
    }

    public static ResourceLoader getResourceLoader() {
        ResourceLoader resourceLoader = resourceLoaderRef.get();
        if (resourceLoader == null && !resourceLoaderRef.compareAndSet(null, resourceLoader = new ResourceLoader())) {
            resourceLoader = resourceLoaderRef.get();
        }
        return resourceLoader;
    }

    public static Recoverer getRecoverer() {
        Recoverer recoverer = recovererRef.get();
        if (recoverer == null && !recovererRef.compareAndSet(null, recoverer = new Recoverer())) {
            recoverer = recovererRef.get();
        }
        return recoverer;
    }

    public static Executor getExecutor() {
        Executor executor = executorRef.get();
        if (executor == null) {
            if (TransactionManagerServices.getConfiguration().isAsynchronous2Pc()) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("using AsyncExecutor");
                }
                executor = new AsyncExecutor();
            } else {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("using SyncExecutor");
                }
                executor = new SyncExecutor();
            }
            if (!executorRef.compareAndSet(null, executor)) {
                executor.shutdown();
                executor = executorRef.get();
            }
        }
        return executor;
    }

    public static ExceptionAnalyzer getExceptionAnalyzer() {
        ExceptionAnalyzer analyzer = exceptionAnalyzerRef.get();
        if (analyzer == null) {
            String exceptionAnalyzerName = TransactionManagerServices.getConfiguration().getExceptionAnalyzer();
            analyzer = new DefaultExceptionAnalyzer();
            if (exceptionAnalyzerName != null) {
                try {
                    analyzer = (ExceptionAnalyzer)ClassLoaderUtils.loadClass(exceptionAnalyzerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "failed to initialize custom exception analyzer, using default one instead", ex);
                }
            }
            if (!exceptionAnalyzerRef.compareAndSet(null, analyzer)) {
                analyzer.shutdown();
                analyzer = exceptionAnalyzerRef.get();
            }
        }
        return analyzer;
    }

    public static boolean isTransactionManagerRunning() {
        return transactionManager != null;
    }

    public static boolean isTaskSchedulerRunning() {
        return taskSchedulerRef.get() != null;
    }

    protected static synchronized void clear() {
        transactionManager = null;
        transactionSynchronizationRegistryRef.set(null);
        configurationRef.set(null);
        journalRef.set(null);
        taskSchedulerRef.set(null);
        resourceLoaderRef.set(null);
        recovererRef.set(null);
        executorRef.set(null);
        exceptionAnalyzerRef.set(null);
    }
}

