/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.internal;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRollbackSystemException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.utils.Decoder;
import java.util.List;
import javax.transaction.xa.XAException;

public class BitronixMultiSystemException
extends BitronixSystemException {
    private final transient List<? extends Exception> exceptions;
    private final transient List<XAResourceHolderState> resourceStates;

    public BitronixMultiSystemException(String string, List<? extends Exception> exceptions, List<XAResourceHolderState> resourceStates) {
        super(string);
        this.exceptions = exceptions;
        this.resourceStates = resourceStates;
    }

    public String getMessage() {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("collected ");
        errorMessage.append(this.exceptions.size());
        errorMessage.append(" exception(s):");
        for (int i = 0; i < this.exceptions.size(); ++i) {
            errorMessage.append(System.getProperty("line.separator"));
            Throwable throwable = this.exceptions.get(i);
            String message = throwable.getMessage();
            XAResourceHolderState holderState = this.resourceStates.get(i);
            if (holderState != null) {
                errorMessage.append(" [");
                errorMessage.append(holderState.getUniqueName());
                errorMessage.append(" - ");
            }
            errorMessage.append(throwable.getClass().getName());
            if (throwable instanceof XAException) {
                XAException xaEx = (XAException)throwable;
                errorMessage.append("(");
                errorMessage.append(Decoder.decodeXAExceptionErrorCode(xaEx));
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(xaEx);
                if (extraErrorDetails != null) {
                    errorMessage.append(" - ").append(extraErrorDetails);
                }
                errorMessage.append(")");
            }
            errorMessage.append(" - ");
            errorMessage.append(message);
            errorMessage.append("]");
        }
        return errorMessage.toString();
    }

    public boolean isUnilateralRollback() {
        for (Throwable throwable : this.exceptions) {
            if (throwable instanceof BitronixRollbackSystemException) continue;
            return false;
        }
        return true;
    }

    public List<? extends Exception> getExceptions() {
        return this.exceptions;
    }

    public List<XAResourceHolderState> getResourceStates() {
        return this.resourceStates;
    }
}

