/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.internal;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import java.util.logging.Logger;

public class ThreadContext {
    private static final Logger log = Logger.getLogger(ThreadContext.class.toString());
    private static final ThreadLocal<ThreadContext> context = ThreadLocal.withInitial(ThreadContext::new);
    private volatile BitronixTransaction transaction;
    private volatile int timeout = TransactionManagerServices.getConfiguration().getDefaultTransactionTimeout();

    private ThreadContext() {
    }

    public static ThreadContext getContext() {
        return context.get();
    }

    public BitronixTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(BitronixTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("transaction parameter cannot be null");
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("assigning <" + transaction + "> to <" + this + ">");
        }
        this.transaction = transaction;
    }

    public void clearTransaction() {
        this.transaction = null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout == 0) {
            int defaultValue = TransactionManagerServices.getConfiguration().getDefaultTransactionTimeout();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resetting default timeout of thread context to default value of " + defaultValue + "s");
            }
            this.timeout = defaultValue;
        } else {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("changing default timeout of thread context to " + timeout + "s");
            }
            this.timeout = timeout;
        }
    }

    public String toString() {
        return "a ThreadContext (" + System.identityHashCode(this) + ") with transaction " + this.transaction + ", default timeout " + this.timeout + "s";
    }
}

