/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.internal;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.BitronixXAException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Uid;
import bitronix.tm.utils.UidGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class XAResourceManager {
    private static final Logger log = Logger.getLogger(XAResourceManager.class.toString());
    private final Uid gtrid;
    private final Scheduler<XAResourceHolderState> resources = new Scheduler();

    public XAResourceManager(Uid gtrid) {
        this.gtrid = gtrid;
    }

    public boolean delist(XAResourceHolderState xaResourceHolderState, int flag) throws XAException {
        if (this.findXAResourceHolderState(xaResourceHolderState.getXAResource()) != null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("delisting resource " + xaResourceHolderState);
            }
            xaResourceHolderState.end(flag);
            return true;
        }
        log.warning("trying to delist resource that has not been previously enlisted: " + xaResourceHolderState);
        return false;
    }

    public XAResourceHolderState findXAResourceHolderState(XAResource xaResource) {
        for (XAResourceHolderState xaResourceHolderState : this.resources) {
            if (xaResourceHolderState.getXAResource() != xaResource) continue;
            return xaResourceHolderState;
        }
        return null;
    }

    public void suspend() throws XAException {
        for (XAResourceHolderState xaResourceHolderState : this.resources) {
            if (xaResourceHolderState.isEnded()) continue;
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("suspending " + xaResourceHolderState);
            }
            xaResourceHolderState.end(0x4000000);
        }
    }

    public void resume() throws XAException {
        ArrayList<XAResourceHolderState> toBeReEnlisted = new ArrayList<XAResourceHolderState>();
        for (XAResourceHolderState xaResourceHolderState : this.resources) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resuming " + xaResourceHolderState);
            }
            toBeReEnlisted.add(new XAResourceHolderState(xaResourceHolderState));
        }
        if (!toBeReEnlisted.isEmpty() && LogDebugCheck.isDebugEnabled()) {
            log.finer("re-enlisting " + toBeReEnlisted.size() + " resource(s)");
        }
        for (XAResourceHolderState xaResourceHolderState : toBeReEnlisted) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("re-enlisting resource " + xaResourceHolderState);
            }
            try {
                this.enlist(xaResourceHolderState);
                xaResourceHolderState.getXAResourceHolder().putXAResourceHolderState(xaResourceHolderState.getXid(), xaResourceHolderState);
            }
            catch (BitronixSystemException ex) {
                throw new BitronixXAException("error re-enlisting resource during resume: " + xaResourceHolderState, -3, (Throwable)((Object)ex));
            }
        }
    }

    public void enlist(XAResourceHolderState xaResourceHolderState) throws XAException, BitronixSystemException {
        List<XAResourceHolderState> alwaysLastResources;
        int flag;
        BitronixXid xid;
        XAResourceHolderState alreadyEnlistedHolder = this.findXAResourceHolderState(xaResourceHolderState.getXAResource());
        if (alreadyEnlistedHolder != null && !alreadyEnlistedHolder.isEnded()) {
            xaResourceHolderState.setXid(alreadyEnlistedHolder.getXid());
            log.warning("ignoring enlistment of already enlisted but not ended resource " + xaResourceHolderState);
            return;
        }
        XAResourceHolderState toBeJoinedHolderState = null;
        if (alreadyEnlistedHolder != null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resource already enlisted but has been ended eligible for join: " + alreadyEnlistedHolder);
            }
            toBeJoinedHolderState = this.getManagedResourceWithSameRM(xaResourceHolderState);
        }
        if (toBeJoinedHolderState != null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("joining " + xaResourceHolderState + " with " + toBeJoinedHolderState);
            }
            xid = toBeJoinedHolderState.getXid();
            flag = 0x200000;
        } else {
            xid = UidGenerator.generateXid(this.gtrid);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("creating new branch with " + xid);
            }
            flag = 0;
        }
        if (flag != 0x200000 && xaResourceHolderState.getTwoPcOrderingPosition() == Scheduler.ALWAYS_LAST_POSITION.intValue() && !TransactionManagerServices.getConfiguration().isAllowMultipleLrc() && (alwaysLastResources = this.resources.getByNaturalOrderForPosition(Scheduler.ALWAYS_LAST_POSITION)) != null && !alwaysLastResources.isEmpty()) {
            throw new BitronixSystemException("cannot enlist more than one non-XA resource, tried enlisting " + xaResourceHolderState + ", already enlisted: " + alwaysLastResources.get(0));
        }
        xaResourceHolderState.setXid(xid);
        xaResourceHolderState.start(flag);
        if (toBeJoinedHolderState != null) {
            this.resources.remove(toBeJoinedHolderState);
        }
        this.resources.add(xaResourceHolderState, xaResourceHolderState.getTwoPcOrderingPosition());
    }

    private XAResourceHolderState getManagedResourceWithSameRM(XAResourceHolderState xaResourceHolderState) throws XAException {
        if (!xaResourceHolderState.getUseTmJoin()) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("join disabled on resource " + xaResourceHolderState);
            }
            return null;
        }
        for (XAResourceHolderState alreadyEnlistedHolderState : this.resources) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("checking joinability of " + xaResourceHolderState + " with " + alreadyEnlistedHolderState);
            }
            if (alreadyEnlistedHolderState.isEnded() && !alreadyEnlistedHolderState.isSuspended() && xaResourceHolderState.getXAResource().isSameRM(alreadyEnlistedHolderState.getXAResource())) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("resources are joinable");
                }
                return alreadyEnlistedHolderState;
            }
            if (!LogDebugCheck.isDebugEnabled()) continue;
            log.finer("resources are not joinable");
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("no joinable resource found for " + xaResourceHolderState);
        }
        return null;
    }

    public void clearXAResourceHolderStates() {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("clearing XAResourceHolder states on " + this.resources.size() + " resource(s)");
        }
        Iterator<XAResourceHolderState> it = this.resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState xaResourceHolderState = it.next();
            XAResourceHolder resourceHolder = xaResourceHolderState.getXAResourceHolder();
            resourceHolder.removeXAResourceHolderState(xaResourceHolderState.getXid());
            boolean stillExists = resourceHolder.isExistXAResourceHolderStatesForGtrid(this.gtrid);
            if (stillExists) {
                log.warning("resource " + resourceHolder + " did not clean up " + resourceHolder.getXAResourceHolderStateCountForGtrid(this.gtrid) + "transaction states for GTRID [" + this.gtrid + "]");
            } else if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resource " + resourceHolder + " cleaned up all transaction states for GTRID [" + this.gtrid + "]");
            }
            it.remove();
        }
    }

    public Set<String> collectUniqueNames() {
        HashSet<String> names = new HashSet<String>(this.resources.size());
        for (XAResourceHolderState xaResourceHolderState : this.resources) {
            names.add(xaResourceHolderState.getUniqueName());
        }
        return Collections.unmodifiableSet(names);
    }

    public SortedSet<Integer> getNaturalOrderPositions() {
        return Collections.unmodifiableSortedSet(this.resources.getNaturalOrderPositions());
    }

    public SortedSet<Integer> getReverseOrderPositions() {
        return Collections.unmodifiableSortedSet(this.resources.getReverseOrderPositions());
    }

    public List<XAResourceHolderState> getNaturalOrderResourcesForPosition(Integer position) {
        return Collections.unmodifiableList(this.resources.getByNaturalOrderForPosition(position));
    }

    public List<XAResourceHolderState> getReverseOrderResourcesForPosition(Integer position) {
        return Collections.unmodifiableList(this.resources.getByReverseOrderForPosition(position));
    }

    public List<XAResourceHolderState> getAllResources() {
        ArrayList<XAResourceHolderState> result = new ArrayList<XAResourceHolderState>(this.resources.size());
        for (Integer positionKey : this.resources.getNaturalOrderPositions()) {
            result.addAll(this.resources.getByNaturalOrderForPosition(positionKey));
        }
        return Collections.unmodifiableList(result);
    }

    public int size() {
        return this.resources.size();
    }

    public Uid getGtrid() {
        return this.gtrid;
    }

    public String toString() {
        return "a XAResourceManager with GTRID [" + this.gtrid + "] and " + this.resources;
    }
}

