/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.jndi;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.ResourceRegistrar;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;

public class BitronixContext
implements Context {
    private static final Logger log = Logger.getLogger(BitronixContext.class.toString());
    private final String userTransactionName = TransactionManagerServices.getConfiguration().getJndiUserTransactionName();
    private final String synchronizationRegistryName;
    private boolean closed = false;

    public BitronixContext() {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("binding transaction manager at name '" + this.userTransactionName + "'");
        }
        this.synchronizationRegistryName = TransactionManagerServices.getConfiguration().getJndiTransactionSynchronizationRegistryName();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("binding synchronization registry at name '" + this.synchronizationRegistryName + "'");
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    private void checkClosed() throws ServiceUnavailableException {
        if (this.closed) {
            throw new ServiceUnavailableException("context is closed");
        }
    }

    @Override
    public Object lookup(String s) throws NamingException {
        Referenceable o;
        this.checkClosed();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking up '" + s + "'");
        }
        if ((o = this.userTransactionName.equals(s) ? TransactionManagerServices.getTransactionManager() : (this.synchronizationRegistryName.equals(s) ? TransactionManagerServices.getTransactionSynchronizationRegistry() : ResourceRegistrar.get(s))) == null) {
            throw new NameNotFoundException("unable to find a bound object at name '" + s + "'");
        }
        return o;
    }

    @Override
    public void bind(Name name, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name name, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(Name name, Name name1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String s, String s1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(Name name) {
        return BitronixNameParser.INSTANCE;
    }

    @Override
    public NameParser getNameParser(String s) {
        return BitronixNameParser.INSTANCE;
    }

    @Override
    public Name composeName(Name name, Name name1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String composeName(String s, String s1) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String toString() {
        return "a BitronixContext with userTransactionName='" + this.userTransactionName + "' and synchronizationRegistryName='" + this.synchronizationRegistryName + "'";
    }

    private static final class BitronixNameParser
    implements NameParser {
        private static final BitronixNameParser INSTANCE = new BitronixNameParser();

        private BitronixNameParser() {
        }

        @Override
        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    }
}

