/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.journal.CorruptedTransactionLogException;
import bitronix.tm.journal.Journal;
import bitronix.tm.journal.JournalRecord;
import bitronix.tm.journal.MigratableJournal;
import bitronix.tm.journal.ReadableJournal;
import bitronix.tm.journal.TransactionLogAppender;
import bitronix.tm.journal.TransactionLogCursor;
import bitronix.tm.journal.TransactionLogIterator;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Uid;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskJournal
implements Journal,
MigratableJournal,
ReadableJournal {
    private static final Logger log = Logger.getLogger(DiskJournal.class.toString());
    private final AtomicReference<TransactionLogAppender> activeTla;
    private final Lock conservativeJournalingLock = new ReentrantLock();
    private final ReadWriteLock swapForceLock = new ReentrantReadWriteLock(true);
    private final Object positionLock = new Object();
    private final AtomicBoolean needsForce;
    private final Configuration configuration = TransactionManagerServices.getConfiguration();
    private TransactionLogAppender tla1;
    private TransactionLogAppender tla2;

    public DiskJournal() {
        this.needsForce = new AtomicBoolean();
        this.activeTla = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(int status, Uid gtrid, Set<String> uniqueNames) throws IOException {
        if (this.activeTla.get() == null) {
            throw new IOException("cannot write log, disk logger is not open");
        }
        if (this.configuration.isFilterLogStatus() && status != 8 && status != 3 && status != 5) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("filtered out write to log for status " + Decoder.decodeStatus(status));
            }
            return;
        }
        TransactionLogRecord tlog = new TransactionLogRecord(status, gtrid, uniqueNames);
        try {
            if (this.configuration.isConservativeJournaling()) {
                this.conservativeJournalingLock.lock();
            }
            Object object = this.positionLock;
            synchronized (object) {
                boolean rollover = this.activeTla.get().setPositionAndAdvance(tlog);
                if (rollover) {
                    this.swapForceLock.writeLock().lock();
                    try {
                        this.swapJournalFiles();
                        this.activeTla.get().setPositionAndAdvance(tlog);
                    }
                    finally {
                        this.swapForceLock.writeLock().unlock();
                    }
                }
                this.swapForceLock.readLock().lock();
            }
            try {
                this.activeTla.get().writeLog(tlog);
                this.needsForce.set(true);
            }
            finally {
                this.swapForceLock.readLock().unlock();
            }
        }
        finally {
            if (this.configuration.isConservativeJournaling()) {
                this.conservativeJournalingLock.unlock();
            }
        }
    }

    private synchronized void swapJournalFiles() throws IOException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("swapping journal log file to " + this.getPassiveTransactionLogAppender());
        }
        this.activeTla.get().force();
        TransactionLogAppender passiveTla = this.getPassiveTransactionLogAppender();
        passiveTla.rewind();
        List<TransactionLogRecord> danglingLogs = this.activeTla.get().getDanglingLogs();
        for (TransactionLogRecord tlog : danglingLogs) {
            boolean rolloverError = passiveTla.setPositionAndAdvance(tlog);
            if (rolloverError) {
                throw new IOException("moving in-flight transactions the rollover log file would have resulted in an overflow of that file");
            }
            passiveTla.writeLog(tlog);
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer(danglingLogs.size() + " dangling record(s) copied to passive log file");
        }
        this.activeTla.get().clearDanglingLogs();
        passiveTla.setTimestamp(MonotonicClock.currentTimeMillis());
        passiveTla.force();
        this.activeTla.set(passiveTla);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("journal log files swapped");
        }
    }

    private synchronized TransactionLogAppender getPassiveTransactionLogAppender() {
        return this.tla1 == this.activeTla.get() ? this.tla2 : this.tla1;
    }

    @Override
    public synchronized void open() throws IOException {
        if (this.activeTla.get() != null) {
            log.warning("disk journal already open");
            return;
        }
        File file1 = new File(this.configuration.getLogPart1Filename());
        File file2 = new File(this.configuration.getLogPart2Filename());
        if (!file1.exists() && !file2.exists()) {
            log.finer("creation of log files");
            DiskJournal.createLogfile(file2, this.configuration.getMaxLogSizeInMb());
            long before = MonotonicClock.currentTimeMillis();
            while (MonotonicClock.currentTimeMillis() < before + 100L) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            DiskJournal.createLogfile(file1, this.configuration.getMaxLogSizeInMb());
        }
        if (file1.length() != file2.length()) {
            if (!this.configuration.isSkipCorruptedLogs()) {
                throw new IOException("transaction log files are not of the same length, assuming they're corrupt");
            }
            log.severe("transaction log files are not of the same length: corrupted files?");
        }
        long maxFileLength = Math.max(file1.length(), file2.length());
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("disk journal files max length: " + maxFileLength);
        }
        this.tla1 = new TransactionLogAppender(file1, maxFileLength);
        this.tla2 = new TransactionLogAppender(file2, maxFileLength);
        byte cleanStatus = this.pickActiveJournalFile(this.tla1, this.tla2);
        if (cleanStatus != 0) {
            log.warning("active log file is unclean, did you call BitronixTransactionManager.shutdown() at the end of the last run?");
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("disk journal opened");
        }
    }

    private static void createLogfile(File logfile, int maxLogSizeInMb) throws IOException {
        boolean deleted;
        if (logfile.isDirectory()) {
            throw new IOException("log file is referring to a directory: " + logfile.getAbsolutePath());
        }
        if (logfile.exists() && !(deleted = logfile.delete())) {
            throw new IOException("log file exists but cannot be overwritten: " + logfile.getAbsolutePath());
        }
        if (logfile.getParentFile() != null) {
            logfile.getParentFile().mkdirs();
        }
        try (RandomAccessFile raf = new RandomAccessFile(logfile, "rw");){
            raf.seek(0L);
            raf.writeInt(1114926712);
            raf.writeLong(MonotonicClock.currentTimeMillis());
            raf.writeByte(0);
            raf.writeLong(21L);
            byte[] buffer = new byte[4096];
            int length = maxLogSizeInMb * 1024 * 1024 / 4096;
            for (int i = 0; i < length; ++i) {
                raf.write(buffer);
            }
        }
    }

    private synchronized byte pickActiveJournalFile(TransactionLogAppender tla1, TransactionLogAppender tla2) throws IOException {
        if (tla1.getTimestamp() > tla2.getTimestamp()) {
            this.activeTla.set(tla1);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("logging to file 1: " + this.activeTla);
            }
        } else {
            this.activeTla.set(tla2);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("logging to file 2: " + this.activeTla);
            }
        }
        byte cleanState = this.activeTla.get().getState();
        this.activeTla.get().setState((byte)-1);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("log file activated, forcing file state to disk");
        }
        this.activeTla.get().force();
        return cleanState;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.activeTla.get() == null) {
            return;
        }
        try {
            this.tla1.close();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "cannot close " + this.tla1, ex);
        }
        this.tla1 = null;
        try {
            this.tla2.close();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "cannot close " + this.tla2, ex);
        }
        this.tla2 = null;
        this.activeTla.set(null);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("disk journal closed");
        }
    }

    @Override
    public void force() throws IOException {
        if (this.activeTla.get() == null) {
            throw new IOException("cannot force log writing, disk logger is not open");
        }
        if (this.needsForce.get() && this.configuration.isForcedWriteEnabled()) {
            this.swapForceLock.writeLock().lock();
            try {
                this.activeTla.get().force();
                this.needsForce.set(false);
            }
            finally {
                this.swapForceLock.writeLock().unlock();
            }
        }
    }

    @Override
    public Map<Uid, JournalRecord> collectDanglingRecords() throws IOException {
        if (this.activeTla.get() == null) {
            throw new IOException("cannot collect dangling records, disk logger is not open");
        }
        return DiskJournal.collectDanglingRecords(this.activeTla.get());
    }

    @Override
    public void migrateTo(Journal other) throws IOException {
        if (other == this) {
            throw new IllegalArgumentException("cannot migrate a journal to itself (this == otherJournal)");
        }
        if (other == null) {
            throw new IllegalArgumentException("the migration target journal cannot be null");
        }
        Iterator<JournalRecord> iterator = this.collectDanglingRecords().values().iterator();
        while (iterator.hasNext()) {
            JournalRecord record;
            JournalRecord jr = record = iterator.next();
            other.log(jr.getStatus(), jr.getGtrid(), jr.getUniqueNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Uid, JournalRecord> collectDanglingRecords(TransactionLogAppender tla) throws IOException {
        HashMap<Uid, JournalRecord> danglingRecords = new HashMap<Uid, JournalRecord>(64);
        try (TransactionLogCursor tlc = tla.getCursor();){
            int committing = 0;
            Integer committed = 0;
            while (true) {
                TransactionLogRecord tlog;
                try {
                    tlog = tlc.readLog();
                }
                catch (CorruptedTransactionLogException ex) {
                    if (TransactionManagerServices.getConfiguration().isSkipCorruptedLogs()) {
                        log.log(Level.SEVERE, "skipping corrupted log", ex);
                        continue;
                    }
                    throw ex;
                }
                if (tlog == null) break;
                int status = tlog.getStatus();
                if (status == 8) {
                    danglingRecords.put(tlog.getGtrid(), tlog);
                    ++committing;
                }
                if (status != 3 && status != 5 && status != 4) continue;
                committed = DiskJournal.processTransaction(danglingRecords, tlog, committed);
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("collected dangling records of " + tla + ", committing: " + committing + ", committed: " + committed + ", delta: " + danglingRecords.size());
            }
        }
        return danglingRecords;
    }

    private static int processTransaction(Map<Uid, JournalRecord> danglingRecords, TransactionLogRecord tlog, int committed) {
        JournalRecord rec = danglingRecords.get(tlog.getGtrid());
        if (rec != null) {
            HashSet<String> recUniqueNames = new HashSet<String>(rec.getUniqueNames());
            recUniqueNames.removeAll(tlog.getUniqueNames());
            if (recUniqueNames.isEmpty()) {
                danglingRecords.remove(tlog.getGtrid());
                ++committed;
            } else {
                danglingRecords.put(tlog.getGtrid(), new TransactionLogRecord(rec.getStatus(), rec.getGtrid(), recUniqueNames));
            }
        }
        return committed;
    }

    @Override
    public synchronized void unsafeReadRecordsInto(Collection<JournalRecord> target, boolean includeInvalid) throws IOException {
        if (this.activeTla.get() == null) {
            throw new IOException("cannot read records, disk logger is not open");
        }
        Iterator<TransactionLogRecord> i = DiskJournal.iterateRecords(this.activeTla.get(), includeInvalid);
        while (i != null && i.hasNext()) {
            target.add(i.next());
        }
    }

    private static Iterator<TransactionLogRecord> iterateRecords(TransactionLogAppender tla, boolean skipCrcCheck) throws IOException {
        TransactionLogCursor tlc = tla.getCursor();
        TransactionLogIterator it = new TransactionLogIterator(tlc, skipCrcCheck);
        try {
            if (it.hasNext()) {
                return it;
            }
            return null;
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw ex;
        }
    }

    @Override
    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "error shutting down disk journal. Transaction log integrity could be compromised!", ex);
        }
    }
}

