/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.journal.CorruptedTransactionLogException;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Uid;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.logging.Logger;

public class TransactionLogCursor
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(TransactionLogCursor.class.toString());
    private static final String CORRUPTED_LOGS = "corrupted log found at position ";
    private final FileInputStream fis;
    private final FileChannel fileChannel;
    private final long endPosition;
    private final ByteBuffer page;
    private long currentPosition;

    TransactionLogCursor(File file) throws IOException {
        this.fis = new FileInputStream(file);
        this.fileChannel = this.fis.getChannel();
        this.page = ByteBuffer.allocate(8192);
        this.fileChannel.position(13L);
        this.fileChannel.read(this.page);
        this.page.rewind();
        this.endPosition = this.page.getLong();
        this.currentPosition = 21L;
    }

    TransactionLogRecord readLog() throws IOException {
        return this.readLog(false);
    }

    TransactionLogRecord readLog(boolean skipCrcCheck) throws IOException {
        if (this.currentPosition >= this.endPosition) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("end of transaction log file reached at " + this.currentPosition);
            }
            return null;
        }
        int status = this.page.getInt();
        int recordLength = this.page.getInt();
        this.currentPosition += 8L;
        if (this.page.position() + recordLength + 8 > this.page.limit()) {
            this.page.compact();
            this.fileChannel.read(this.page);
            this.page.rewind();
        }
        int endOfRecordPosition = this.page.position() + recordLength;
        if (this.currentPosition + (long)recordLength > this.endPosition) {
            this.page.position(this.page.position() + recordLength);
            this.currentPosition += (long)recordLength;
            throw new CorruptedTransactionLogException(CORRUPTED_LOGS + this.currentPosition + " (record terminator outside of file bounds: " + this.currentPosition + recordLength + " of " + this.endPosition + ", recordLength: " + recordLength + ")");
        }
        int headerLength = this.page.getInt();
        long time = this.page.getLong();
        int sequenceNumber = this.page.getInt();
        int crc32 = this.page.getInt();
        byte gtridSize = this.page.get();
        this.currentPosition += 21L;
        this.page.mark();
        this.page.position(endOfRecordPosition - 4);
        int endCode = this.page.getInt();
        this.page.reset();
        if (endCode != 2020504642) {
            throw new CorruptedTransactionLogException(CORRUPTED_LOGS + this.currentPosition + " (no record terminator found)");
        }
        if (21 + gtridSize > recordLength) {
            this.page.position(endOfRecordPosition);
            throw new CorruptedTransactionLogException(CORRUPTED_LOGS + this.currentPosition + " (GTRID size too long)");
        }
        byte[] gtridArray = new byte[gtridSize];
        this.page.get(gtridArray);
        this.currentPosition += (long)gtridSize;
        Uid gtrid = new Uid(gtridArray);
        int uniqueNamesCount = this.page.getInt();
        this.currentPosition += 4L;
        HashSet<String> uniqueNames = new HashSet<String>();
        int currentReadCount = 21 + gtridSize + 4;
        for (int i = 0; i < uniqueNamesCount; ++i) {
            short length = this.page.getShort();
            this.currentPosition += 2L;
            if ((currentReadCount += 2 + length) > recordLength) {
                this.page.position(endOfRecordPosition);
                throw new CorruptedTransactionLogException(CORRUPTED_LOGS + this.currentPosition + " (unique names too long, " + (i + 1) + " out of " + uniqueNamesCount + ", length: " + length + ", currentReadCount: " + currentReadCount + ", recordLength: " + recordLength + ")");
            }
            byte[] nameBytes = new byte[length];
            this.page.get(nameBytes);
            this.currentPosition += (long)length;
            uniqueNames.add(new String(nameBytes, StandardCharsets.US_ASCII));
        }
        int cEndRecord = this.page.getInt();
        this.currentPosition += 4L;
        TransactionLogRecord tlog = new TransactionLogRecord(status, recordLength, headerLength, time, sequenceNumber, crc32, gtrid, uniqueNames, cEndRecord);
        if (!skipCrcCheck && !tlog.isCrc32Correct()) {
            this.page.position(endOfRecordPosition);
            throw new CorruptedTransactionLogException(CORRUPTED_LOGS + this.currentPosition + "(invalid CRC, recorded: " + tlog.getCrc32() + ", calculated: " + tlog.calculateCrc32() + ")");
        }
        return tlog;
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
        this.fileChannel.close();
    }
}

