/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.utils.Decoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;

public class TransactionLogHeader {
    public static final byte CLEAN_LOG_STATE = 0;
    public static final byte UNCLEAN_LOG_STATE = -1;
    static final long FORMAT_ID_HEADER = 0L;
    static final long TIMESTAMP_HEADER = 4L;
    static final long STATE_HEADER = 12L;
    static final long CURRENT_POSITION_HEADER = 13L;
    static final long HEADER_LENGTH = 21L;
    private static final Logger log = Logger.getLogger(TransactionLogHeader.class.toString());
    private final FileChannel fc;
    private final long maxFileLength;
    private volatile long timestamp;
    private volatile byte state;
    private volatile long position;

    public TransactionLogHeader(FileChannel fc, long maxFileLength) throws IOException {
        this.fc = fc;
        this.maxFileLength = maxFileLength;
        fc.position(0L);
        ByteBuffer buf = ByteBuffer.allocate(21);
        while (buf.hasRemaining()) {
            this.fc.read(buf);
        }
        buf.flip();
        buf.getInt();
        this.timestamp = buf.getLong();
        this.state = buf.get();
        this.position = buf.getLong();
        fc.position(this.position);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("read header " + this);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(timestamp);
        buf.flip();
        while (buf.hasRemaining()) {
            this.fc.write(buf, 4L + (long)buf.position());
        }
        this.timestamp = timestamp;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put(state);
        buf.flip();
        while (buf.hasRemaining()) {
            this.fc.write(buf, 12L + (long)buf.position());
        }
        this.state = state;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) throws IOException {
        if (position < 21L) {
            throw new IOException("invalid position " + position + " (too low)");
        }
        if (position > this.maxFileLength) {
            throw new IOException("invalid position " + position + " (too high)");
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(position);
        buf.flip();
        while (buf.hasRemaining()) {
            this.fc.write(buf, 13L + (long)buf.position());
        }
        this.position = position;
        this.fc.position(position);
    }

    void rewind() throws IOException {
        this.setPosition(21L);
    }

    public String toString() {
        return "a Bitronix TransactionLogHeader with timestamp=" + this.timestamp + ", state=" + Decoder.decodeHeaderState(this.state) + ", position=" + this.position;
    }
}

