/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.journal.CorruptedTransactionLogException;
import bitronix.tm.journal.TransactionLogCursor;
import bitronix.tm.journal.TransactionLogRecord;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransactionLogIterator
implements Iterator<TransactionLogRecord> {
    private static final Logger log = Logger.getLogger(TransactionLogIterator.class.toString());
    private final TransactionLogCursor tlc;
    private final boolean skipCrcCheck;
    private TransactionLogRecord tlog;

    public TransactionLogIterator(TransactionLogCursor tlc, boolean skipCrcCheck) {
        this.tlc = tlc;
        this.skipCrcCheck = skipCrcCheck;
    }

    @Override
    public boolean hasNext() {
        while (this.tlog == null) {
            try {
                this.processTlog();
            }
            catch (CorruptedTransactionLogException ctle) {
                log.log(Level.SEVERE, "Skipping Corrupted Log", ctle);
            }
            catch (BitronixSystemException bse) {
                log.log(Level.FINEST, "Skipping Corrupted Log", (Throwable)((Object)bse));
                break;
            }
            catch (IOException e) {
                throw new BitronixRuntimeException(e);
            }
        }
        return this.tlog != null;
    }

    private void processTlog() throws IOException, BitronixSystemException {
        try {
            this.tlog = this.tlc.readLog(this.skipCrcCheck);
            if (this.tlog == null) {
                throw new BitronixSystemException("Breaker");
            }
        }
        catch (CorruptedTransactionLogException ex) {
            if (TransactionManagerServices.getConfiguration().isSkipCorruptedLogs()) {
                throw ex;
            }
            throw ex;
        }
    }

    @Override
    public TransactionLogRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            TransactionLogRecord transactionLogRecord = this.tlog;
            return transactionLogRecord;
        }
        finally {
            this.tlog = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

