/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.journal.JournalRecord;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Uid;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;

public class TransactionLogRecord
implements JournalRecord {
    private static final int RECORD_HEADER_LENGTH = 28;
    private static final AtomicInteger sequenceGenerator = new AtomicInteger();
    private final int status;
    private final int headerLength;
    private final long time;
    private final int sequenceNumber;
    private final Uid gtrid;
    private final SortedSet<String> uniqueNames;
    private final int endRecord;
    private int recordLength;
    private int crc32;
    private long writePosition;

    TransactionLogRecord(int status, int recordLength, int headerLength, long time, int sequenceNumber, int crc32, Uid gtrid, Set<String> uniqueNames, int endRecord) {
        this.status = status;
        this.recordLength = recordLength;
        this.headerLength = headerLength;
        this.time = time;
        this.sequenceNumber = sequenceNumber;
        this.crc32 = crc32;
        this.gtrid = gtrid;
        this.uniqueNames = new TreeSet<String>(uniqueNames);
        this.endRecord = endRecord;
    }

    public TransactionLogRecord(int status, Uid gtrid, Set<String> uniqueNames) {
        this.status = status;
        this.time = MonotonicClock.currentTimeMillis();
        this.sequenceNumber = sequenceGenerator.incrementAndGet();
        this.gtrid = gtrid;
        this.uniqueNames = new TreeSet<String>(uniqueNames);
        this.endRecord = 2020504642;
        this.headerLength = 28;
        this.refresh();
    }

    private void refresh() {
        this.crc32 = this.calculateCrc32();
    }

    int calculateCrc32() {
        int total = 0;
        for (String string : this.uniqueNames) {
            total += 2 + string.length();
        }
        this.recordLength = total + this.getFixedRecordLength();
        ByteBuffer buf = ByteBuffer.allocate(24 + this.gtrid.length() + 4 + total + 4);
        buf.putInt(this.status);
        buf.putInt(this.recordLength);
        buf.putInt(this.headerLength);
        buf.putLong(this.time);
        buf.putInt(this.sequenceNumber);
        buf.put(this.gtrid.getArray());
        buf.putInt(this.uniqueNames.size());
        for (String name : this.uniqueNames) {
            buf.putShort((short)name.length());
            buf.put(name.getBytes(StandardCharsets.US_ASCII));
        }
        buf.putInt(this.endRecord);
        CRC32 cRC32 = new CRC32();
        cRC32.update(buf.array());
        return (int)cRC32.getValue();
    }

    private int getFixedRecordLength() {
        return 21 + this.gtrid.length() + 4 + 4;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Uid getGtrid() {
        return this.gtrid;
    }

    @Override
    public Set<String> getUniqueNames() {
        return Collections.unmodifiableSortedSet(this.uniqueNames);
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public boolean isValid() {
        return this.isCrc32Correct();
    }

    public boolean isCrc32Correct() {
        return this.calculateCrc32() == this.getCrc32();
    }

    public int getCrc32() {
        return this.crc32;
    }

    @Override
    public Map<String, ?> getRecordProperties() {
        LinkedHashMap<String, Integer> props = new LinkedHashMap<String, Integer>(4);
        props.put("recordLength", this.recordLength);
        props.put("headerLength", this.headerLength);
        props.put("sequenceNumber", this.sequenceNumber);
        props.put("crc32", this.crc32);
        return props;
    }

    int getRecordLength() {
        return this.recordLength;
    }

    int getHeaderLength() {
        return this.headerLength;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    long getWritePosition() {
        return this.writePosition;
    }

    void setWritePosition(long position) {
        this.writePosition = position;
    }

    int getEndRecord() {
        return this.endRecord;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("a Bitronix TransactionLogRecord with ");
        sb.append("status=");
        sb.append(Decoder.decodeStatus(this.status));
        sb.append(", ");
        sb.append("recordLength=");
        sb.append(this.recordLength);
        sb.append(", ");
        sb.append("headerLength=");
        sb.append(this.headerLength);
        sb.append(", ");
        sb.append("time=");
        sb.append(this.time);
        sb.append(", ");
        sb.append("sequenceNumber=");
        sb.append(this.sequenceNumber);
        sb.append(", ");
        sb.append("crc32=");
        sb.append(this.crc32);
        sb.append(", ");
        sb.append("gtrid=");
        sb.append(this.gtrid.toString());
        sb.append(", ");
        sb.append("uniqueNames=");
        Iterator it = this.uniqueNames.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    int calculateTotalRecordSize() {
        return this.recordLength + 4 + 4;
    }
}

