/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.recovery;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.journal.JournalRecord;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.recovery.RecoveryHelper;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.Uid;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;

public class IncrementalRecoverer {
    private static final Logger log = Logger.getLogger(IncrementalRecoverer.class.toString());
    private static final String FAILED_RESOURCE_STRING = "failed recovering resource ";

    private IncrementalRecoverer() {
    }

    public static void recover(XAResourceProducer xaResourceProducer) throws RecoveryException {
        String uniqueName = xaResourceProducer.getUniqueName();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("start of incremental recovery on resource " + uniqueName);
        }
        try {
            XAResourceHolderState xaResourceHolderState = xaResourceProducer.startRecovery();
            boolean success = true;
            Set<BitronixXid> xids = RecoveryHelper.recover(xaResourceHolderState);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer(xids.size() + " dangling transaction(s) found on resource");
            }
            Map<Uid, JournalRecord> danglingRecords = TransactionManagerServices.getJournal().collectDanglingRecords();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer(danglingRecords.size() + " dangling transaction(s) found in journal");
            }
            int commitCount = 0;
            int rollbackCount = 0;
            for (BitronixXid xid : xids) {
                Uid gtrid = xid.getGlobalTransactionIdUid();
                JournalRecord tlog = danglingRecords.get(gtrid);
                if (tlog != null) {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("committing " + xid);
                    }
                    success &= RecoveryHelper.commit(xaResourceHolderState, xid);
                    IncrementalRecoverer.updateJournal(xid.getGlobalTransactionIdUid(), uniqueName, 3);
                    ++commitCount;
                    continue;
                }
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("rolling back " + xid);
                }
                success &= RecoveryHelper.rollback(xaResourceHolderState, xid);
                IncrementalRecoverer.updateJournal(xid.getGlobalTransactionIdUid(), uniqueName, 4);
                ++rollbackCount;
            }
            if (!success) {
                throw new RecoveryException("error recovering resource '" + uniqueName + "' due to an incompatible heuristic decision");
            }
            xaResourceProducer.setFailed(false);
            log.info("incremental recovery committed " + commitCount + " dangling transaction(s) and rolled back " + rollbackCount + " aborted transaction(s) on resource [" + uniqueName + "]" + (String)(TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
        }
        catch (IOException | RuntimeException | XAException ex) {
            xaResourceProducer.setFailed(true);
            throw new RecoveryException(FAILED_RESOURCE_STRING + uniqueName, ex);
        }
        catch (RecoveryException ex) {
            xaResourceProducer.setFailed(true);
            throw ex;
        }
        finally {
            xaResourceProducer.endRecovery();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("end of incremental recovery on resource " + uniqueName);
            }
        }
    }

    private static void updateJournal(Uid gtrid, String uniqueName, int status) throws IOException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("updating journal, adding " + Decoder.decodeStatus(status) + " entry for [" + uniqueName + "] on GTRID [" + gtrid + "]");
        }
        HashSet<String> participatingUniqueNames = new HashSet<String>();
        participatingUniqueNames.add(uniqueName);
        TransactionManagerServices.getJournal().log(status, gtrid, participatingUniqueNames);
    }
}

