/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.recovery;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.journal.JournalRecord;
import bitronix.tm.recovery.DanglingTransaction;
import bitronix.tm.recovery.RecovererMBean;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.recovery.RecoveryHelper;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.ManagementRegistrar;
import bitronix.tm.utils.Service;
import bitronix.tm.utils.Uid;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class Recoverer
implements Runnable,
Service,
RecovererMBean {
    private static final Logger log = Logger.getLogger(Recoverer.class.toString());
    private final Map<String, XAResourceProducer> registeredResources = new HashMap<String, XAResourceProducer>();
    private final Map<String, Set<BitronixXid>> recoveredXidSets = new HashMap<String, Set<BitronixXid>>();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final String jmxName;
    private volatile Exception completionException;
    private volatile int committedCount;
    private volatile int rolledbackCount;
    private volatile int executionsCount;

    public Recoverer() {
        String serverId = TransactionManagerServices.getConfiguration().getServerId();
        if (serverId == null) {
            serverId = "";
        }
        this.jmxName = "bitronix.tm:type=Recoverer,ServerId=" + ManagementRegistrar.makeValidName(serverId);
        ManagementRegistrar.register(this.jmxName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isRunning.compareAndSet(false, true)) {
            log.info("recoverer is already running, abandoning this recovery request");
            return;
        }
        try {
            this.committedCount = 0;
            this.rolledbackCount = 0;
            long oldestTransactionTimestamp = Long.MAX_VALUE;
            Map<Uid, JournalRecord> danglingRecords = TransactionManagerServices.getJournal().collectDanglingRecords();
            Class<ResourceRegistrar> clazz = ResourceRegistrar.class;
            synchronized (ResourceRegistrar.class) {
                for (String name : ResourceRegistrar.getResourcesUniqueNames()) {
                    this.registeredResources.put(name, ResourceRegistrar.get(name));
                }
                if (TransactionManagerServices.isTransactionManagerRunning()) {
                    oldestTransactionTimestamp = TransactionManagerServices.getTransactionManager().getOldestInFlightTransactionTimestamp();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                this.recoverAllResources();
                Set<Uid> committedGtrids = this.commitDanglingTransactions(oldestTransactionTimestamp, danglingRecords);
                this.committedCount = committedGtrids.size();
                this.rolledbackCount = this.rollbackAbortedTransactions(oldestTransactionTimestamp, committedGtrids);
                if (this.executionsCount == 0 || this.committedCount > 0 || this.rolledbackCount > 0) {
                    log.info("recovery committed " + this.committedCount + " dangling transaction(s) and rolled back " + this.rolledbackCount + " aborted transaction(s) on " + this.registeredResources.size() + " resource(s) [" + this.getRegisteredResourcesUniqueNames() + "]" + (String)(TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
                } else if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("recovery committed " + this.committedCount + " dangling transaction(s) and rolled back " + this.rolledbackCount + " aborted transaction(s) on " + this.registeredResources.size() + " resource(s) [" + this.getRegisteredResourcesUniqueNames() + "]" + (String)(TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
                }
                this.completionException = null;
            }
        }
        catch (Exception ex) {
            this.completionException = ex;
            log.log(Level.WARNING, "recovery failed, registered resource(s): " + this.getRegisteredResourcesUniqueNames(), ex);
        }
        finally {
            this.recoveredXidSets.clear();
            this.registeredResources.clear();
            ++this.executionsCount;
            this.isRunning.set(false);
        }
        {
            return;
        }
    }

    private void recoverAllResources() {
        for (Map.Entry<String, XAResourceProducer> entry : new HashMap<String, XAResourceProducer>(this.registeredResources).entrySet()) {
            String uniqueName = entry.getKey();
            XAResourceProducer producer = entry.getValue();
            try {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("performing recovery on " + uniqueName);
                }
                Set<BitronixXid> xids = this.recover(producer);
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("recovered " + xids.size() + " XID(s) from resource " + uniqueName);
                }
                this.recoveredXidSets.put(uniqueName, xids);
                producer.setFailed(false);
            }
            catch (XAException ex) {
                producer.setFailed(true);
                this.registeredResources.remove(uniqueName);
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
                log.log(Level.WARNING, "error running recovery on resource '" + uniqueName + "', resource marked as failed (background recoverer will retry recovery) (error=" + Decoder.decodeXAExceptionErrorCode(ex) + ")" + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
            }
            catch (Exception ex) {
                if (producer != null) {
                    producer.setFailed(true);
                }
                this.registeredResources.remove(uniqueName);
                log.log(Level.WARNING, "error running recovery on resource '" + uniqueName + "', resource marked as failed (background recoverer will retry recovery)", ex);
            }
        }
    }

    private Set<Uid> commitDanglingTransactions(long oldestTransactionTimestamp, Map<Uid, JournalRecord> danglingRecords) throws IOException, RecoveryException {
        HashSet<Uid> committedGtrids = new HashSet<Uid>();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("found " + danglingRecords.size() + " dangling record(s) in journal");
        }
        for (Map.Entry<Uid, JournalRecord> entry : danglingRecords.entrySet()) {
            Uid gtrid = entry.getKey();
            JournalRecord tlog = entry.getValue();
            Set<String> uniqueNames = tlog.getUniqueNames();
            Set<DanglingTransaction> danglingTransactions = this.getDanglingTransactionsInRecoveredXids(uniqueNames, tlog.getGtrid());
            long txTimestamp = gtrid.extractTimestamp();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("recovered XID timestamp: " + txTimestamp + " - oldest in-flight TX timestamp: " + oldestTransactionTimestamp);
            }
            if (txTimestamp < oldestTransactionTimestamp) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("committing dangling transaction with GTRID " + gtrid);
                }
                this.commit(danglingTransactions);
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("committed dangling transaction with GTRID " + gtrid);
                }
                committedGtrids.add(gtrid);
                Set<String> participatingUniqueNames = this.filterParticipatingUniqueNamesInRecoveredXids(uniqueNames);
                if (!participatingUniqueNames.isEmpty()) {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("updating journal's transaction with GTRID " + gtrid + " status to COMMITTED for names [" + Recoverer.buildUniqueNamesString(participatingUniqueNames) + "]");
                    }
                    TransactionManagerServices.getJournal().log(3, tlog.getGtrid(), participatingUniqueNames);
                    continue;
                }
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("not updating journal's transaction with GTRID " + gtrid + " status to COMMITTED as no resource could be found (incremental recovery will need to clean this)");
                }
                committedGtrids.remove(gtrid);
                continue;
            }
            if (!LogDebugCheck.isDebugEnabled()) continue;
            log.finer("skipping in-flight transaction with GTRID " + gtrid);
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("committed " + committedGtrids.size() + " dangling transaction(s)");
        }
        return committedGtrids;
    }

    private int rollbackAbortedTransactions(long oldestTransactionTimestamp, Set<Uid> committedGtrids) throws RecoveryException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("rolling back aborted branch(es)");
        }
        int rollbackCount = 0;
        for (Map.Entry<String, Set<BitronixXid>> entry : this.recoveredXidSets.entrySet()) {
            String uniqueName = entry.getKey();
            Set<BitronixXid> recoveredXids = entry.getValue();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("checking " + recoveredXids.size() + " branch(es) on " + uniqueName + " for rollback");
            }
            int count = this.rollbackAbortedBranchesOfResource(oldestTransactionTimestamp, uniqueName, recoveredXids, committedGtrids);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("checked " + recoveredXids.size() + " branch(es) on " + uniqueName + " for rollback");
            }
            rollbackCount += count;
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("rolled back " + rollbackCount + " aborted branch(es)");
        }
        return rollbackCount;
    }

    private String getRegisteredResourcesUniqueNames() {
        return Recoverer.buildUniqueNamesString(this.registeredResources.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BitronixXid> recover(XAResourceProducer producer) throws XAException, RecoveryException {
        if (producer == null) {
            throw new IllegalArgumentException("recoverable resource cannot be null");
        }
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("running recovery on " + producer);
            }
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            Set<BitronixXid> set = RecoveryHelper.recover(xaResourceHolderState);
            return set;
        }
        finally {
            producer.endRecovery();
        }
    }

    private Set<DanglingTransaction> getDanglingTransactionsInRecoveredXids(Set<String> uniqueNames, Uid gtrid) {
        HashSet<DanglingTransaction> danglingTransactions = new HashSet<DanglingTransaction>();
        for (String uniqueName : uniqueNames) {
            Set<BitronixXid> recoveredXids;
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("finding dangling transaction(s) in recovered XID(s) of resource " + uniqueName);
            }
            if ((recoveredXids = this.recoveredXidSets.get(uniqueName)) == null) {
                if (!LogDebugCheck.isDebugEnabled()) continue;
                log.finer("resource " + uniqueName + " did not recover, skipping commit");
                continue;
            }
            for (BitronixXid recoveredXid : recoveredXids) {
                if (!gtrid.equals(recoveredXid.getGlobalTransactionIdUid())) continue;
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("found a recovered XID matching dangling log's GTRID " + gtrid + " in resource " + uniqueName);
                }
                danglingTransactions.add(new DanglingTransaction(uniqueName, recoveredXid));
            }
        }
        return danglingTransactions;
    }

    private void commit(Set<DanglingTransaction> danglingTransactions) throws RecoveryException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer(danglingTransactions.size() + " branch(es) to commit");
        }
        for (DanglingTransaction danglingTransaction : danglingTransactions) {
            Xid xid = danglingTransaction.getXid();
            String uniqueName = danglingTransaction.getUniqueName();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("committing branch with XID " + xid + " on " + uniqueName);
            }
            this.commit(uniqueName, xid);
        }
    }

    private Set<String> filterParticipatingUniqueNamesInRecoveredXids(Set<String> uniqueNames) {
        HashSet<String> recoveredUniqueNames = new HashSet<String>();
        for (String uniqueName : uniqueNames) {
            Set<BitronixXid> recoveredXids;
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("finding dangling transaction(s) in recovered XID(s) of resource " + uniqueName);
            }
            if ((recoveredXids = this.recoveredXidSets.get(uniqueName)) == null) {
                if (!LogDebugCheck.isDebugEnabled()) continue;
                log.finer("cannot find resource '" + uniqueName + "' present in the journal, leaving it for incremental recovery");
                continue;
            }
            recoveredUniqueNames.add(uniqueName);
        }
        return recoveredUniqueNames;
    }

    private static String buildUniqueNamesString(Set<String> uniqueNames) {
        StringBuilder resourcesUniqueNames = new StringBuilder();
        Iterator<String> it = uniqueNames.iterator();
        while (it.hasNext()) {
            String uniqueName = it.next();
            resourcesUniqueNames.append(uniqueName);
            if (!it.hasNext()) continue;
            resourcesUniqueNames.append(", ");
        }
        return resourcesUniqueNames.toString();
    }

    private int rollbackAbortedBranchesOfResource(long oldestTransactionTimestamp, String uniqueName, Set<BitronixXid> recoveredXids, Set<Uid> committedGtrids) throws RecoveryException {
        int abortedCount = 0;
        for (BitronixXid recoveredXid : recoveredXids) {
            boolean success;
            if (committedGtrids.contains(recoveredXid.getGlobalTransactionIdUid())) {
                if (!LogDebugCheck.isDebugEnabled()) continue;
                log.finer("XID has been committed, skipping rollback: " + recoveredXid + " on " + uniqueName);
                continue;
            }
            long txTimestamp = recoveredXid.getGlobalTransactionIdUid().extractTimestamp();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("recovered XID timestamp: " + txTimestamp + " - oldest in-flight TX timestamp: " + oldestTransactionTimestamp);
            }
            if (txTimestamp >= oldestTransactionTimestamp) {
                if (!LogDebugCheck.isDebugEnabled()) continue;
                log.finer("skipping XID of in-flight transaction: " + recoveredXid);
                continue;
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("rolling back in-doubt branch with XID " + recoveredXid + " on " + uniqueName);
            }
            if (!(success = this.rollback(uniqueName, recoveredXid))) continue;
            ++abortedCount;
        }
        return abortedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commit(String uniqueName, Xid xid) throws RecoveryException {
        XAResourceProducer producer = this.registeredResources.get(uniqueName);
        try {
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            boolean bl = RecoveryHelper.commit(xaResourceHolderState, xid);
            return bl;
        }
        finally {
            producer.endRecovery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollback(String uniqueName, Xid xid) throws RecoveryException {
        XAResourceProducer producer = this.registeredResources.get(uniqueName);
        if (producer == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resource " + uniqueName + " has not recovered, skipping rollback");
            }
            return false;
        }
        try {
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            boolean bl = RecoveryHelper.rollback(xaResourceHolderState, xid);
            return bl;
        }
        finally {
            producer.endRecovery();
        }
    }

    @Override
    public void shutdown() {
        ManagementRegistrar.unregister(this.jmxName);
    }

    @Override
    public int getCommittedCount() {
        return this.committedCount;
    }

    @Override
    public int getRolledbackCount() {
        return this.rolledbackCount;
    }

    @Override
    public Exception getCompletionException() {
        return this.completionException;
    }

    @Override
    public int getExecutionsCount() {
        return this.executionsCount;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }
}

