/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.recovery;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.Uid;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class RecoveryHelper {
    private static final Logger log = Logger.getLogger(RecoveryHelper.class.toString());
    private static final String XIDS_ON = " xid(s) on ";
    private static final String UNABLE_TO_COMMIT_INDOUBT = "unable to commit in-doubt branch on resource ";
    private static final String EXTRA_ERROR = ", extra error=";
    private static final String ERROR = " - error=";
    private static final String UNABLE_TO_ROLLBACK_INDOUBT = "unable to rollback aborted in-doubt branch on resource ";

    private RecoveryHelper() {
    }

    public static Set<BitronixXid> recover(XAResourceHolderState xaResourceHolderState) throws XAException {
        HashSet<BitronixXid> xids;
        block15: {
            int xidCount;
            block14: {
                xids = new HashSet<BitronixXid>();
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("recovering with STARTRSCAN");
                }
                try {
                    xidCount = RecoveryHelper.recover(xaResourceHolderState, xids, 0x1000000);
                }
                catch (XAException ex) {
                    if (xaResourceHolderState.getIgnoreRecoveryFailures()) {
                        if (LogDebugCheck.isDebugEnabled()) {
                            log.log(Level.FINER, "ignoring recovery failure on resource " + xaResourceHolderState, ex);
                        }
                        return Collections.emptySet();
                    }
                    throw ex;
                }
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("STARTRSCAN recovered " + xidCount + XIDS_ON + xaResourceHolderState);
                }
                try {
                    while (xidCount > 0) {
                        if (LogDebugCheck.isDebugEnabled()) {
                            log.finer("recovering with NOFLAGS");
                        }
                        xidCount = RecoveryHelper.recover(xaResourceHolderState, xids, 0);
                        if (!LogDebugCheck.isDebugEnabled()) continue;
                        log.finer("NOFLAGS recovered " + xidCount + XIDS_ON + xaResourceHolderState);
                    }
                }
                catch (XAException ex) {
                    if (!LogDebugCheck.isDebugEnabled()) break block14;
                    log.log(Level.FINER, "NOFLAGS recovery call failed", ex);
                }
            }
            try {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("recovering with ENDRSCAN");
                }
                xidCount = RecoveryHelper.recover(xaResourceHolderState, xids, 0x800000);
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("ENDRSCAN recovered " + xidCount + XIDS_ON + xaResourceHolderState);
                }
            }
            catch (XAException ex) {
                if (!LogDebugCheck.isDebugEnabled()) break block15;
                log.log(Level.FINER, "ENDRSCAN recovery call failed", ex);
            }
        }
        return xids;
    }

    private static int recover(XAResourceHolderState resourceHolderState, Set<BitronixXid> alreadyRecoveredXids, int flags) throws XAException {
        Xid[] xids = resourceHolderState.getXAResource().recover(flags);
        if (xids == null) {
            return 0;
        }
        boolean currentNodeOnly = TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery();
        HashSet<BitronixXid> freshlyRecoveredXids = new HashSet<BitronixXid>();
        for (Xid xid : xids) {
            if (xid.getFormatId() != 1114926712) {
                if (!LogDebugCheck.isDebugEnabled()) continue;
                log.finer("skipping non-bitronix XID " + xid + "(format ID: " + xid.getFormatId() + " GTRID: " + new Uid(xid.getGlobalTransactionId()) + "BQUAL: " + new Uid(xid.getBranchQualifier()) + ")");
                continue;
            }
            BitronixXid bitronixXid = new BitronixXid(xid);
            if (currentNodeOnly) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("recovering XIDs generated by this node only - recovered XIDs' GTRID must contain this JVM uniqueId");
                }
                byte[] extractedServerId = bitronixXid.getGlobalTransactionIdUid().extractServerId();
                byte[] jvmUniqueId = TransactionManagerServices.getConfiguration().buildServerIdArray();
                if (extractedServerId.length == 0) {
                    log.severe("skipping XID " + bitronixXid + " as its GTRID's serverId is null. It looks like the disk journal is corrupted!");
                    continue;
                }
                if (!Arrays.equals(jvmUniqueId, extractedServerId)) {
                    String extractedServerIdString = new String(extractedServerId);
                    String jvmUniqueIdString = new String(jvmUniqueId);
                    if (!LogDebugCheck.isDebugEnabled()) continue;
                    log.finer("skipping XID " + bitronixXid + " as its GTRID's serverId <" + extractedServerIdString + "> does not match this JVM unique ID <" + jvmUniqueIdString + ">");
                    continue;
                }
            } else if (LogDebugCheck.isDebugEnabled()) {
                log.finer("recovering all XIDs regardless of this JVM uniqueId");
            }
            if (alreadyRecoveredXids.contains(bitronixXid)) {
                if (!LogDebugCheck.isDebugEnabled()) continue;
                log.finer("already recovered XID " + bitronixXid + ", skipping it");
                continue;
            }
            if (freshlyRecoveredXids.contains(bitronixXid)) {
                log.warning("resource " + resourceHolderState.getUniqueName() + " recovered two identical XIDs within the same recover call: " + bitronixXid);
                continue;
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("recovered " + bitronixXid);
            }
            freshlyRecoveredXids.add(bitronixXid);
        }
        alreadyRecoveredXids.addAll(freshlyRecoveredXids);
        return freshlyRecoveredXids.size();
    }

    public static boolean commit(XAResourceHolderState xaResourceHolderState, Xid xid) {
        String uniqueName = xaResourceHolderState.getUniqueName();
        boolean success = true;
        boolean forget = false;
        try {
            xaResourceHolderState.getXAResource().commit(xid, false);
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            if (ex.errorCode == -4) {
                log.log(Level.SEVERE, UNABLE_TO_COMMIT_INDOUBT + uniqueName + " - error=XAER_NOTA" + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ". Forgotten heuristic?", ex);
            }
            if (ex.errorCode == 7) {
                log.info(UNABLE_TO_COMMIT_INDOUBT + uniqueName + ERROR + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ". Heuristic decision compatible with the global state of this transaction.");
                forget = true;
            }
            if (ex.errorCode == 8 || ex.errorCode == 5 || ex.errorCode == 6) {
                log.severe(UNABLE_TO_COMMIT_INDOUBT + uniqueName + ERROR + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ". Heuristic decision incompatible with the global state of this transaction!");
                forget = true;
                success = false;
            }
            log.log(Level.SEVERE, UNABLE_TO_COMMIT_INDOUBT + uniqueName + ERROR + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ".", ex);
            success = false;
        }
        if (forget) {
            RecoveryHelper.processForget(xaResourceHolderState, xid, uniqueName);
        }
        return success;
    }

    private static void processForget(XAResourceHolderState xaResourceHolderState, Xid xid, String uniqueName) {
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("forgetting XID " + xid + " on resource " + uniqueName);
            }
            xaResourceHolderState.getXAResource().forget(xid);
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            log.log(Level.SEVERE, "unable to forget XID " + xid + " on resource " + uniqueName + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails), ex);
        }
    }

    public static boolean rollback(XAResourceHolderState xaResourceHolderState, Xid xid) {
        String uniqueName = xaResourceHolderState.getUniqueName();
        boolean success = true;
        boolean forget = false;
        try {
            xaResourceHolderState.getXAResource().rollback(xid);
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            if (ex.errorCode == -4) {
                log.log(Level.SEVERE, UNABLE_TO_ROLLBACK_INDOUBT + uniqueName + " - error=XAER_NOTA" + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ". Forgotten heuristic?", ex);
            }
            if (ex.errorCode == 6) {
                log.info(UNABLE_TO_ROLLBACK_INDOUBT + uniqueName + ERROR + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ". Heuristic decision compatible with the global state of this transaction.");
                forget = true;
            }
            if (ex.errorCode == 8 || ex.errorCode == 5 || ex.errorCode == 7) {
                log.severe(UNABLE_TO_ROLLBACK_INDOUBT + uniqueName + ERROR + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ". Heuristic decision incompatible with the global state of this transaction!");
                forget = true;
                success = false;
            }
            log.log(Level.SEVERE, UNABLE_TO_ROLLBACK_INDOUBT + uniqueName + ERROR + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : EXTRA_ERROR + extraErrorDetails) + ".", ex);
            success = false;
        }
        if (forget) {
            RecoveryHelper.processForget(xaResourceHolderState, xid, uniqueName);
        }
        return success;
    }
}

