/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.InitializationException;
import bitronix.tm.utils.PropertyUtils;
import bitronix.tm.utils.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.XAConnectionFactory;
import javax.sql.XADataSource;

public class ResourceLoader
implements Service {
    private static final Logger log = Logger.getLogger(ResourceLoader.class.toString());
    private static final String JDBC_RESOURCE_CLASSNAME = "bitronix.tm.resource.jdbc.PoolingDataSource";
    private static final String JMS_RESOURCE_CLASSNAME = "bitronix.tm.resource.jms.PoolingConnectionFactory";
    private final Map<String, XAResourceProducer> resourcesByUniqueName = new HashMap<String, XAResourceProducer>();

    public Map<String, XAResourceProducer> getResources() {
        return this.resourcesByUniqueName;
    }

    public int init() {
        String filename = TransactionManagerServices.getConfiguration().getResourceConfigurationFilename();
        if (filename != null) {
            if (!new File(filename).exists()) {
                throw new ResourceConfigurationException("cannot find resources configuration file '" + filename + "', missing or invalid value of property 'bitronix.tm.resource.configuration'");
            }
            log.info("reading resources configuration from " + filename);
            return this.init(filename);
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("no resource configuration file specified");
        }
        return 0;
    }

    private int init(String propertiesFilename) {
        int n;
        FileInputStream fis = new FileInputStream(propertiesFilename);
        try {
            Properties properties = new Properties();
            properties.load(fis);
            n = this.initXAResourceProducers(properties);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new InitializationException("cannot create resource loader", ex);
            }
        }
        fis.close();
        return n;
    }

    int initXAResourceProducers(Properties properties) {
        Map<String, List<PropertyPair>> entries = this.buildConfigurationEntriesMap(properties);
        int errorCount = 0;
        for (Map.Entry<String, List<PropertyPair>> entry : entries.entrySet()) {
            List<PropertyPair> propertyPairs;
            String uniqueName = entry.getKey();
            XAResourceProducer producer = this.buildXAResourceProducer(uniqueName, propertyPairs = entry.getValue());
            if (ResourceRegistrar.get(producer.getUniqueName()) != null) {
                if (!LogDebugCheck.isDebugEnabled()) continue;
                log.finer("resource already registered, skipping it:" + producer.getUniqueName());
                continue;
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("creating resource " + producer);
            }
            try {
                producer.init();
            }
            catch (ResourceConfigurationException ex) {
                log.log(Level.WARNING, "unable to create resource with unique name " + producer.getUniqueName(), ex);
                producer.close();
                ++errorCount;
            }
            this.resourcesByUniqueName.put(producer.getUniqueName(), producer);
        }
        return errorCount;
    }

    private Map<String, List<PropertyPair>> buildConfigurationEntriesMap(Properties properties) {
        HashMap<String, List<PropertyPair>> entries = new HashMap<String, List<PropertyPair>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("resource.")) continue;
            this.configureConfigurationKeyParts(key, value, entries);
        }
        return entries;
    }

    private XAResourceProducer buildXAResourceProducer(String configuredName, List<PropertyPair> propertyPairs) {
        String lastPropertyName = "className";
        try {
            XAResourceProducer producer = this.createBean(configuredName, propertyPairs);
            for (PropertyPair propertyPair : propertyPairs) {
                lastPropertyName = propertyPair.getName();
                String propertyValue = propertyPair.getValue();
                PropertyUtils.setProperty(producer, lastPropertyName, propertyValue);
            }
            if (producer.getUniqueName() == null) {
                throw new ResourceConfigurationException("missing mandatory property [uniqueName] of resource [" + configuredName + "] in resources configuration file");
            }
            return producer;
        }
        catch (ResourceConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ResourceConfigurationException("cannot configure resource for configuration entries with name [" + configuredName + "] - failing property is [" + lastPropertyName + "]", ex);
        }
    }

    private void configureConfigurationKeyParts(String key, String value, Map<String, List<PropertyPair>> entries) {
        String[] keyParts = key.split("\\.");
        if (keyParts.length < 3) {
            log.warning("ignoring invalid entry in configuration file: " + key);
        } else {
            String configuredName = keyParts[1];
            StringBuilder propertyName = new StringBuilder(keyParts[2]);
            if (keyParts.length > 3) {
                for (int i = 3; i < keyParts.length; ++i) {
                    propertyName.append(".").append(keyParts[i]);
                }
            }
            List pairs = entries.computeIfAbsent(configuredName, k -> new ArrayList());
            pairs.add(new PropertyPair(propertyName.toString(), value));
        }
    }

    private XAResourceProducer createBean(String configuredName, List<PropertyPair> propertyPairs) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        for (PropertyPair propertyPair : propertyPairs) {
            if (!"className".equals(propertyPair.getName())) continue;
            String className = propertyPair.getValue();
            XAResourceProducer producer = ResourceLoader.instantiate(className);
            if (producer == null) {
                throw new ResourceConfigurationException("property [className] of resource [" + configuredName + "] in resources configuration file must be the name of a class implementing either javax.sql.XADataSource or javax.jms.XAConnectionFactory");
            }
            return producer;
        }
        throw new ResourceConfigurationException("missing mandatory property [className] for resource [" + configuredName + "] in resources configuration file");
    }

    private static XAResourceProducer instantiate(String xaResourceClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class clazz = ClassLoaderUtils.loadClass(xaResourceClassName);
        if (XADataSource.class.isAssignableFrom(clazz)) {
            return (XAResourceProducer)ClassLoaderUtils.loadClass(JDBC_RESOURCE_CLASSNAME).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (XAConnectionFactory.class.isAssignableFrom(clazz)) {
            return (XAResourceProducer)ClassLoaderUtils.loadClass(JMS_RESOURCE_CLASSNAME).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return null;
    }

    @Override
    public synchronized void shutdown() {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("resource loader has registered " + this.resourcesByUniqueName.entrySet().size() + " resource(s), unregistering them now");
        }
        for (Map.Entry<String, XAResourceProducer> entry : this.resourcesByUniqueName.entrySet()) {
            XAResourceProducer producer = entry.getValue();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("closing " + producer);
            }
            try {
                producer.close();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "error closing resource " + producer, ex);
            }
        }
        this.resourcesByUniqueName.clear();
    }

    private final class PropertyPair {
        private final String name;
        private final String value;

        public PropertyPair(String key, String value) {
            this.name = key;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "/" + this.value;
        }
    }
}

