/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ResourceObjectFactory
implements ObjectFactory {
    private static final Logger log = Logger.getLogger(ResourceObjectFactory.class.toString());

    @Override
    public Object getObjectInstance(Object obj, Name jndiNameObject, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        XAResourceProducer resource;
        RefAddr refAddr;
        Reference ref = (Reference)obj;
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("referencing resource with reference of type " + ref.getClass());
        }
        if ((refAddr = ref.get("uniqueName")) == null) {
            throw new NamingException("no 'uniqueName' RefAddr found");
        }
        Object content = refAddr.getContent();
        if (!(content instanceof String)) {
            throw new NamingException("'uniqueName' RefAddr content is not of type java.lang.String");
        }
        String uniqueName = (String)content;
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("getting registered resource with uniqueName '" + uniqueName + "'");
        }
        if ((resource = ResourceRegistrar.get(uniqueName)) == null) {
            throw new NamingException("no resource registered with uniqueName '" + uniqueName + "', available resources: " + ResourceRegistrar.getResourcesUniqueNames());
        }
        return resource;
    }
}

