/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.recovery.IncrementalRecoverer;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public final class ResourceRegistrar {
    private static final Logger log = Logger.getLogger(ResourceRegistrar.class.toString());
    private static final Set<ProducerHolder> resources = new CopyOnWriteArraySet<ProducerHolder>();

    private ResourceRegistrar() {
    }

    public static XAResourceProducer get(String uniqueName) {
        if (uniqueName != null) {
            for (ProducerHolder holder : resources) {
                if (!holder.isInitialized() || !uniqueName.equals(holder.getUniqueName())) continue;
                return holder.producer;
            }
        }
        return null;
    }

    public static Set<String> getResourcesUniqueNames() {
        HashSet<String> names = new HashSet<String>(resources.size());
        for (ProducerHolder holder : resources) {
            if (!holder.isInitialized()) continue;
            names.add(holder.getUniqueName());
        }
        return Collections.unmodifiableSet(names);
    }

    public static void register(XAResourceProducer producer) throws RecoveryException {
        block4: {
            try {
                ProducerHolder holder;
                boolean alreadyRunning = TransactionManagerServices.isTransactionManagerRunning();
                ProducerHolder producerHolder = holder = alreadyRunning ? new InitializableProducerHolder(producer) : new ProducerHolder(producer);
                if (resources.add(holder)) {
                    if (holder instanceof InitializableProducerHolder) {
                        ResourceRegistrar.processInitializableProducerHolder(producer, (InitializableProducerHolder)holder);
                    }
                    break block4;
                }
                throw new IllegalStateException("A resource with uniqueName '" + holder.getUniqueName() + "' has already been registered. Cannot register XAResourceProducer '" + producer + "'.");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot register the XAResourceProducer '" + producer + "' caused by invalid input.", e);
            }
        }
    }

    private static boolean processInitializableProducerHolder(XAResourceProducer producer, InitializableProducerHolder holder) throws RecoveryException {
        boolean recovered = false;
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("Transaction manager is running, recovering resource '" + holder.getUniqueName() + "'.");
            }
            IncrementalRecoverer.recover(producer);
            holder.initialize();
            recovered = true;
        }
        finally {
            if (!recovered) {
                resources.remove(holder);
            }
        }
        return recovered;
    }

    public static void unregister(XAResourceProducer producer) {
        ProducerHolder holder = new ProducerHolder(producer);
        if (!resources.remove(holder) && LogDebugCheck.isDebugEnabled()) {
            log.log(Level.FINER, "resource with uniqueName '" + holder.getUniqueName() + "' has not been registered");
        }
    }

    public static XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        boolean debug = LogDebugCheck.isDebugEnabled();
        for (ProducerHolder holder : resources) {
            if (!holder.isInitialized()) continue;
            XAResourceProducer producer = holder.producer;
            Object resourceHolder = producer.findXAResourceHolder(xaResource);
            if (resourceHolder != null) {
                if (debug) {
                    log.finer("XAResource " + xaResource + " belongs to " + resourceHolder + " that itself belongs to " + producer);
                }
                return resourceHolder;
            }
            if (!debug) continue;
            log.finer("XAResource " + xaResource + " does not belong to any resource of " + producer);
        }
        return null;
    }

    private static class InitializableProducerHolder
    extends ProducerHolder {
        private volatile boolean initialized;

        private InitializableProducerHolder(XAResourceProducer producer) {
            super(producer);
        }

        void initialize() {
            this.initialized = true;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        boolean isInitialized() {
            return this.initialized;
        }
    }

    private static class ProducerHolder {
        private final XAResourceProducer producer;

        private ProducerHolder(XAResourceProducer producer) {
            if (producer == null) {
                throw new IllegalArgumentException("XAResourceProducer may not be 'null'. Verify your call to ResourceRegistrar.[un]register(...).");
            }
            String uniqueName = producer.getUniqueName();
            if (uniqueName == null || uniqueName.length() == 0) {
                throw new IllegalArgumentException("The given XAResourceProducer '" + producer + "' does not specify a uniqueName.");
            }
            String transcodedUniqueName = new String(uniqueName.getBytes(StandardCharsets.US_ASCII), StandardCharsets.US_ASCII);
            if (!transcodedUniqueName.equals(uniqueName)) {
                throw new IllegalArgumentException("The given XAResourceProducer's uniqueName '" + uniqueName + "' is not compatible with the charset 'US-ASCII' (transcoding results in '" + transcodedUniqueName + "'). " + System.getProperty("line.separator") + "BTM requires unique names to be compatible with US-ASCII when used with a transaction journal.");
            }
            this.producer = producer;
        }

        public int hashCode() {
            return this.getUniqueName().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProducerHolder)) {
                return false;
            }
            ProducerHolder that = (ProducerHolder)o;
            return this.getUniqueName().equals(that.getUniqueName());
        }

        public String toString() {
            return "ProducerHolder{producer=" + this.producer + ", initialized=" + this.isInitialized() + "}";
        }

        boolean isInitialized() {
            return true;
        }

        String getUniqueName() {
            return this.producer.getUniqueName();
        }
    }
}

