/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.resource.common.AbstractXAStatefulHolder;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceHolderStateVisitor;
import bitronix.tm.utils.Uid;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public abstract class AbstractXAResourceHolder<T extends XAResourceHolder<T>>
extends AbstractXAStatefulHolder<T>
implements XAResourceHolder<T> {
    private static final Logger log = Logger.getLogger(AbstractXAResourceHolder.class.toString());
    private final Map<Uid, Map<Uid, XAResourceHolderState>> xaResourceHolderStates = new HashMap<Uid, Map<Uid, XAResourceHolderState>>();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    protected Map<Uid, XAResourceHolderState> getXAResourceHolderStatesForGtrid(Uid gtrid) {
        this.rwLock.readLock().lock();
        try {
            Map<Uid, XAResourceHolderState> map = this.xaResourceHolderStates.get(gtrid);
            return map;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptVisitorForXAResourceHolderStates(Uid gtrid, XAResourceHolderStateVisitor visitor) {
        this.rwLock.readLock().lock();
        try {
            Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
            if (statesForGtrid != null) {
                for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
                    visitor.visit(xaResourceHolderState);
                }
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public boolean isExistXAResourceHolderStatesForGtrid(Uid gtrid) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.xaResourceHolderStates.containsKey(gtrid);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getXAResourceHolderStateCountForGtrid(Uid gtrid) {
        this.rwLock.readLock().lock();
        try {
            Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
            if (statesForGtrid != null) {
                int n = statesForGtrid.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putXAResourceHolderState(BitronixXid xid, XAResourceHolderState xaResourceHolderState) {
        Uid gtrid = xid.getGlobalTransactionIdUid();
        Uid bqual = xid.getBranchQualifierUid();
        this.rwLock.writeLock().lock();
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("putting XAResourceHolderState [" + xaResourceHolderState + "] on " + this);
            }
            if (!this.xaResourceHolderStates.containsKey(gtrid)) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("GTRID [" + gtrid + "] previously unknown to " + this + ", adding it to the resource's transactions list");
                }
                LinkedHashMap<Uid, XAResourceHolderState> statesForGtrid = new LinkedHashMap<Uid, XAResourceHolderState>(4);
                statesForGtrid.put(bqual, xaResourceHolderState);
                this.xaResourceHolderStates.put(gtrid, statesForGtrid);
            } else {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("GTRID [" + gtrid + "] previously known to " + this + ", adding it to the resource's transactions list");
                }
                Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
                statesForGtrid.put(bqual, xaResourceHolderState);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXAResourceHolderState(BitronixXid xid) {
        Uid gtrid = xid.getGlobalTransactionIdUid();
        Uid bqual = xid.getBranchQualifierUid();
        this.rwLock.writeLock().lock();
        try {
            Map<Uid, XAResourceHolderState> statesForGtrid;
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("removing XAResourceHolderState of xid " + xid + " from " + this);
            }
            if ((statesForGtrid = this.xaResourceHolderStates.get(gtrid)) == null) {
                log.warning("tried to remove unknown GTRID [" + gtrid + "] from " + this + " - Bug?");
                return;
            }
            XAResourceHolderState removed = statesForGtrid.remove(bqual);
            if (removed == null) {
                log.warning("tried to remove unknown BQUAL [" + bqual + "] from " + this + " - Bug?");
                return;
            }
            if (statesForGtrid.isEmpty()) {
                this.xaResourceHolderStates.remove(gtrid);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStateForXAResource(XAResourceHolder<? extends XAResourceHolder> xaResourceHolder) {
        this.rwLock.readLock().lock();
        try {
            for (Map<Uid, XAResourceHolderState> statesForGtrid : this.xaResourceHolderStates.values()) {
                for (XAResourceHolderState otherXaResourceHolderState : statesForGtrid.values()) {
                    if (otherXaResourceHolderState.getXAResource() != xaResourceHolder.getXAResource()) continue;
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("resource " + xaResourceHolder + " is enlisted in another transaction with " + otherXaResourceHolderState.getXid().toString());
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resource not enlisted in any transaction: " + xaResourceHolder);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParticipatingInActiveGlobalTransaction() {
        this.rwLock.readLock().lock();
        try {
            Uid gtrid;
            BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
            Uid uid = gtrid = currentTransaction == null ? null : currentTransaction.getResourceManager().getGtrid();
            if (gtrid == null) {
                boolean bl = false;
                return bl;
            }
            Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
            if (statesForGtrid == null) {
                boolean bl = false;
                return bl;
            }
            for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
                if (xaResourceHolderState == null || !xaResourceHolderState.isStarted() || xaResourceHolderState.isSuspended() || xaResourceHolderState.isEnded()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getXAResourceHolderStateGtrids() {
        this.rwLock.readLock().lock();
        try {
            HashSet<String> gtridsAsStrings = new HashSet<String>();
            for (Uid uid : this.xaResourceHolderStates.keySet()) {
                gtridsAsStrings.add(uid.toString());
            }
            HashSet<String> hashSet = gtridsAsStrings;
            return hashSet;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

