/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.XAStatefulHolder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public abstract class AbstractXAStatefulHolder<T extends XAStatefulHolder<T>>
implements XAStatefulHolder<T> {
    private static final Logger log = Logger.getLogger(AbstractXAStatefulHolder.class.toString());
    private final List<StateChangeListener<T>> stateChangeEventListeners = new CopyOnWriteArrayList<StateChangeListener<T>>();
    private final Date creationDate = new Date();
    private volatile XAStatefulHolder.State state = XAStatefulHolder.State.IN_POOL;

    @Override
    public XAStatefulHolder.State getState() {
        return this.state;
    }

    @Override
    public void setState(XAStatefulHolder.State state) {
        XAStatefulHolder.State oldState = this.state;
        this.fireStateChanging(oldState, state);
        if (oldState == state) {
            throw new IllegalArgumentException("cannot switch state from " + oldState + " to " + state);
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("state changing from " + oldState + " to " + state + " in " + this);
        }
        this.state = state;
        this.fireStateChanged(oldState, state);
    }

    @Override
    public void addStateChangeEventListener(StateChangeListener<T> listener) {
        this.stateChangeEventListeners.add(listener);
    }

    @Override
    public void removeStateChangeEventListener(StateChangeListener<T> listener) {
        this.stateChangeEventListeners.remove(listener);
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    private void fireStateChanging(XAStatefulHolder.State currentState, XAStatefulHolder.State futureState) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("notifying " + this.stateChangeEventListeners.size() + " stateChangeEventListener(s) about state changing from " + currentState + " to " + futureState + " in " + this);
        }
        for (StateChangeListener<AbstractXAStatefulHolder> stateChangeListener : this.stateChangeEventListeners) {
            stateChangeListener.stateChanging(this, currentState, futureState);
        }
    }

    private void fireStateChanged(XAStatefulHolder.State oldState, XAStatefulHolder.State newState) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("notifying " + this.stateChangeEventListeners.size() + " stateChangeEventListener(s) about state changed from " + oldState + " to " + newState + " in " + this);
        }
        for (StateChangeListener<AbstractXAStatefulHolder> stateChangeListener : this.stateChangeEventListeners) {
            stateChangeListener.stateChanged(this, oldState, newState);
        }
    }
}

