/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.resource.common.DeferredReleaseSynchronization;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceHolderStateVisitor;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Uid;
import java.util.List;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;

public final class TransactionContextHelper {
    private static final Logger log = Logger.getLogger(TransactionContextHelper.class.toString());
    private static final String FROM_SPACE = " from ";

    private TransactionContextHelper() {
    }

    public static void enlistInCurrentTransaction(XAResourceHolder<? extends XAResourceHolder> xaResourceHolder) throws SystemException, RollbackException {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        ResourceBean bean = xaResourceHolder.getResourceBean();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("enlisting " + xaResourceHolder + " into " + currentTransaction);
        }
        if (currentTransaction != null) {
            if (currentTransaction.timedOut()) {
                throw new BitronixSystemException("transaction timed out");
            }
            XAResourceHolderState alreadyEnlistedXAResourceHolderState = TransactionContextHelper.getLatestAlreadyEnlistedXAResourceHolderState(xaResourceHolder, currentTransaction);
            if (alreadyEnlistedXAResourceHolderState == null || alreadyEnlistedXAResourceHolderState.isEnded()) {
                currentTransaction.enlistResource(xaResourceHolder.getXAResource());
            } else if (LogDebugCheck.isDebugEnabled()) {
                log.finer("avoiding re-enlistment of already enlisted but not ended resource " + alreadyEnlistedXAResourceHolderState);
            }
        } else if (bean.getAllowLocalTransactions()) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("in local transaction context, skipping enlistment");
            }
        } else {
            throw new BitronixSystemException("resource '" + bean.getUniqueName() + "' cannot be used outside XA transaction scope. Set allowLocalTransactions to true if you want to allow this and you know your resource supports this.");
        }
    }

    public static BitronixTransaction currentTransaction() {
        if (!TransactionManagerServices.isTransactionManagerRunning()) {
            return null;
        }
        return TransactionManagerServices.getTransactionManager().getCurrentTransaction();
    }

    private static XAResourceHolderState getLatestAlreadyEnlistedXAResourceHolderState(XAResourceHolder xaResourceHolder, BitronixTransaction currentTransaction) {
        if (currentTransaction == null) {
            return null;
        }
        class LocalVisitor
        implements XAResourceHolderStateVisitor {
            private XAResourceHolderState latestEnlistedHolder;
            final /* synthetic */ BitronixTransaction val$currentTransaction;

            LocalVisitor(BitronixTransaction bitronixTransaction) {
                this.val$currentTransaction = bitronixTransaction;
            }

            @Override
            public boolean visit(XAResourceHolderState xaResourceHolderState) {
                if (xaResourceHolderState != null && xaResourceHolderState.getXid() != null) {
                    BitronixXid bitronixXid = xaResourceHolderState.getXid();
                    Uid resourceGtrid = bitronixXid.getGlobalTransactionIdUid();
                    Uid currentTransactionGtrid = this.val$currentTransaction.getResourceManager().getGtrid();
                    if (currentTransactionGtrid.equals(resourceGtrid)) {
                        this.latestEnlistedHolder = xaResourceHolderState;
                    }
                }
                return true;
            }
        }
        LocalVisitor xaResourceHolderStateVisitor = new LocalVisitor(currentTransaction);
        xaResourceHolder.acceptVisitorForXAResourceHolderStates(currentTransaction.getResourceManager().getGtrid(), xaResourceHolderStateVisitor);
        return xaResourceHolderStateVisitor.latestEnlistedHolder;
    }

    public static void delistFromCurrentTransaction(XAResourceHolder<? extends XAResourceHolder> xaResourceHolder) throws SystemException {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        ResourceBean bean = xaResourceHolder.getResourceBean();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("delisting " + xaResourceHolder + FROM_SPACE + currentTransaction);
        }
        if (TransactionContextHelper.isInEnlistingGlobalTransactionContext(xaResourceHolder, currentTransaction) && !bean.getDeferConnectionRelease()) {
            class LocalVisitor
            implements XAResourceHolderStateVisitor {
                private SystemException systemException = null;
                final /* synthetic */ BitronixTransaction val$currentTransaction;

                LocalVisitor(BitronixTransaction bitronixTransaction) {
                    this.val$currentTransaction = bitronixTransaction;
                }

                @Override
                public boolean visit(XAResourceHolderState xaResourceHolderState) {
                    if (!xaResourceHolderState.isEnded()) {
                        if (LogDebugCheck.isDebugEnabled()) {
                            log.finer("delisting resource " + xaResourceHolderState + TransactionContextHelper.FROM_SPACE + this.val$currentTransaction);
                        }
                        try {
                            this.val$currentTransaction.delistResource(xaResourceHolderState.getXAResource(), 0x4000000);
                        }
                        catch (SystemException e) {
                            this.systemException = e;
                            return false;
                        }
                    } else if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("avoiding delistment of not enlisted resource " + xaResourceHolderState);
                    }
                    return true;
                }
            }
            LocalVisitor xaResourceHolderStateVisitor = new LocalVisitor(currentTransaction);
            xaResourceHolder.acceptVisitorForXAResourceHolderStates(currentTransaction.getResourceManager().getGtrid(), xaResourceHolderStateVisitor);
            if (xaResourceHolderStateVisitor.systemException != null) {
                throw xaResourceHolderStateVisitor.systemException;
            }
        }
    }

    private static boolean isInEnlistingGlobalTransactionContext(XAResourceHolder<? extends XAResourceHolder> xaResourceHolder, BitronixTransaction currentTransaction) {
        boolean globalTransactionMode = false;
        if (currentTransaction != null && xaResourceHolder.isExistXAResourceHolderStatesForGtrid(currentTransaction.getResourceManager().getGtrid())) {
            globalTransactionMode = true;
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("resource is " + (globalTransactionMode ? "" : "not ") + "in enlisting global transaction context: " + xaResourceHolder);
        }
        return globalTransactionMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void requeue(XAStatefulHolder<? extends XAStatefulHolder> xaStatefulHolder, ResourceBean bean) throws BitronixSystemException {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("requeuing " + xaStatefulHolder + FROM_SPACE + currentTransaction);
        }
        if (!TransactionContextHelper.isInEnlistingGlobalTransactionContext(xaStatefulHolder, currentTransaction)) {
            if (TransactionContextHelper.isEnlistedInSomeTransaction(xaStatefulHolder)) throw new BitronixSystemException("cannot close a resource when its XAResource is taking part in an unfinished global transaction");
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resource not in enlisting global transaction context, immediately releasing to pool " + xaStatefulHolder);
            }
            xaStatefulHolder.setState(XAStatefulHolder.State.IN_POOL);
            return;
        } else if (bean.getDeferConnectionRelease()) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("deferring release to pool of " + xaStatefulHolder);
            }
            if (!TransactionContextHelper.isAlreadyRegisteredForDeferredRelease(xaStatefulHolder, currentTransaction)) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("registering DeferredReleaseSynchronization for " + xaStatefulHolder);
                }
                DeferredReleaseSynchronization synchronization = new DeferredReleaseSynchronization(xaStatefulHolder);
                currentTransaction.getSynchronizationScheduler().add(synchronization, Scheduler.ALWAYS_LAST_POSITION);
            } else if (LogDebugCheck.isDebugEnabled()) {
                log.finer("already registered DeferredReleaseSynchronization for " + xaStatefulHolder);
            }
            xaStatefulHolder.setState(XAStatefulHolder.State.NOT_ACCESSIBLE);
            return;
        } else {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("immediately releasing to pool " + xaStatefulHolder);
            }
            xaStatefulHolder.setState(XAStatefulHolder.State.IN_POOL);
        }
    }

    private static boolean isInEnlistingGlobalTransactionContext(XAStatefulHolder<? extends XAStatefulHolder> xaStatefulHolder, BitronixTransaction currentTransaction) {
        List<XAResourceHolder<XAResourceHolder>> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
        if (xaResourceHolders == null || xaResourceHolders.isEmpty()) {
            return false;
        }
        for (XAResourceHolder<XAResourceHolder> xaResourceHolder : xaResourceHolders) {
            if (!TransactionContextHelper.isInEnlistingGlobalTransactionContext(xaResourceHolder, currentTransaction)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnlistedInSomeTransaction(XAStatefulHolder<? extends XAStatefulHolder> xaStatefulHolder) {
        List<XAResourceHolder<XAResourceHolder>> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
        if (xaResourceHolders == null || xaResourceHolders.isEmpty()) {
            return false;
        }
        for (XAResourceHolder<XAResourceHolder> xaResourceHolder : xaResourceHolders) {
            if (!TransactionContextHelper.isEnlistedInSomeTransaction(xaResourceHolder)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlreadyRegisteredForDeferredRelease(XAStatefulHolder<? extends XAStatefulHolder> xaStatefulHolder, BitronixTransaction currentTransaction) {
        boolean alreadyDeferred;
        boolean bl = alreadyDeferred = TransactionContextHelper.findDeferredRelease(xaStatefulHolder, currentTransaction) != null;
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer(xaStatefulHolder + " is " + (alreadyDeferred ? "" : "not ") + "already registered for deferred release in " + currentTransaction);
        }
        return alreadyDeferred;
    }

    private static boolean isEnlistedInSomeTransaction(XAResourceHolder<? extends XAResourceHolder> xaResourceHolder) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking in in-flight transactions for XAResourceHolderState of " + xaResourceHolder);
        }
        if (!TransactionManagerServices.isTransactionManagerRunning()) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("transaction manager not running, there is no in-flight transaction");
            }
            return false;
        }
        return xaResourceHolder.hasStateForXAResource(xaResourceHolder);
    }

    private static DeferredReleaseSynchronization findDeferredRelease(XAStatefulHolder<? extends XAStatefulHolder> xaStatefulHolder, BitronixTransaction currentTransaction) {
        Scheduler<Synchronization> synchronizationScheduler = currentTransaction.getSynchronizationScheduler();
        for (Synchronization synchronization : synchronizationScheduler) {
            DeferredReleaseSynchronization deferredReleaseSynchronization;
            if (!(synchronization instanceof DeferredReleaseSynchronization) || (deferredReleaseSynchronization = (DeferredReleaseSynchronization)synchronization).getXAStatefulHolder() != xaStatefulHolder) continue;
            return deferredReleaseSynchronization;
        }
        return null;
    }

    public static void recycle(XAStatefulHolder<? extends XAStatefulHolder> xaStatefulHolder) {
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("marking " + xaStatefulHolder + " as recycled in " + currentTransaction);
        }
        if (currentTransaction != null) {
            Scheduler<Synchronization> synchronizationScheduler = currentTransaction.getSynchronizationScheduler();
            DeferredReleaseSynchronization deferredReleaseSynchronization = TransactionContextHelper.findDeferredRelease(xaStatefulHolder, currentTransaction);
            if (deferredReleaseSynchronization != null) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer(xaStatefulHolder + " has been recycled, unregistering deferred release from " + currentTransaction);
                }
                synchronizationScheduler.remove(deferredReleaseSynchronization);
            }
        }
    }
}

