/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.CryptoEngine;
import bitronix.tm.utils.PropertyUtils;
import java.util.Map;
import java.util.logging.Logger;

final class XAFactoryHelper {
    private static final Logger log = Logger.getLogger(XAFactoryHelper.class.toString());
    private static final String PASSWORD_PROPERTY_NAME = "password";

    private XAFactoryHelper() {
    }

    static Object createXAFactory(ResourceBean bean) throws Exception {
        String className = bean.getClassName();
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        Class xaFactoryClass = ClassLoaderUtils.loadClass(className);
        Object xaFactory = xaFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Map.Entry<Object, Object> entry : bean.getDriverProperties().entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (name.endsWith(PASSWORD_PROPERTY_NAME)) {
                value = XAFactoryHelper.decrypt(value.toString());
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("setting vendor property '" + name + "' to '" + value + "'");
            }
            PropertyUtils.setProperty(xaFactory, name, value);
        }
        return xaFactory;
    }

    private static String decrypt(String resourcePassword) throws BitronixSystemException {
        String returned;
        int startIdx = resourcePassword.indexOf(123);
        int endIdx = resourcePassword.indexOf(125);
        if (startIdx != 0 || endIdx == -1) {
            return resourcePassword;
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("resource password is encrypted, decrypting " + resourcePassword);
        }
        String toScan = resourcePassword.substring(endIdx + 1);
        try {
            returned = CryptoEngine.decrypt(toScan);
        }
        catch (Exception e) {
            throw new BitronixSystemException("Unable to decrypt field", e);
        }
        if (returned.charAt(0) == '\u0000') {
            returned = returned.substring(8);
        }
        return returned;
    }
}

