/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.IncrementalRecoverer;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAFactoryHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceHolderStateVisitor;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Uid;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;

public class XAPool<R extends XAResourceHolder<R>, T extends XAStatefulHolder<T>>
implements StateChangeListener<T> {
    private static final Logger log = Logger.getLogger(XAPool.class.toString());
    private final ReentrantReadWriteLock stateTransitionLock = new ReentrantReadWriteLock();
    private final BlockingDeque<T> availablePool = new LinkedBlockingDeque<T>();
    private final Queue<T> accessiblePool = new LinkedList<T>();
    private final Queue<T> inaccessiblePool = new LinkedList<T>();
    private final AtomicInteger poolSize = new AtomicInteger();
    private final Map<Uid, StatefulHolderThreadLocal<T>> statefulHolderTransactionMap = new ConcurrentHashMap<Uid, StatefulHolderThreadLocal<T>>();
    private final ResourceBean bean;
    private final XAResourceProducer<R, T> xaResourceProducer;
    private final Object xaFactory;
    private final AtomicBoolean failed = new AtomicBoolean();
    private final Object poolGrowthShrinkLock = new Object();

    public XAPool(XAResourceProducer<R, T> xaResourceProducer, ResourceBean bean, Object xaFactory) throws Exception {
        this.xaResourceProducer = xaResourceProducer;
        this.bean = bean;
        if (bean.getMaxPoolSize() < 1 || bean.getMinPoolSize() > bean.getMaxPoolSize()) {
            throw new IllegalArgumentException("cannot create a pool with min " + bean.getMinPoolSize() + " connection(s) and max " + bean.getMaxPoolSize() + " connection(s)");
        }
        if (bean.getAcquireIncrement() < 1) {
            throw new IllegalArgumentException("cannot create a pool with a connection acquisition increment less than 1, configured value is " + bean.getAcquireIncrement());
        }
        this.xaFactory = xaFactory == null ? XAFactoryHelper.createXAFactory(bean) : xaFactory;
        this.init();
        if (bean.getIgnoreRecoveryFailures()) {
            log.warning("resource '" + bean.getUniqueName() + "' is configured to ignore recovery failures, make sure this setting is not enabled on a production system!");
        }
    }

    private void init() throws Exception {
        this.growUntilMinPoolSize();
        if (this.bean.getMaxIdleTime() > 0 || this.bean.getMaxLifeTime() > 0) {
            TransactionManagerServices.getTaskScheduler().schedulePoolShrinking(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growUntilMinPoolSize() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("growing " + this + " to minimum pool size " + this.bean.getMinPoolSize());
            }
            for (int i = this.totalPoolSize(); i < this.bean.getMinPoolSize(); ++i) {
                this.createPooledObject(this.xaFactory);
            }
        }
    }

    public int totalPoolSize() {
        return this.poolSize.get();
    }

    private void createPooledObject(Object xaFactory) throws Exception {
        T xaStatefulHolder = this.xaResourceProducer.createPooledConnection(xaFactory, this.bean);
        xaStatefulHolder.addStateChangeEventListener(this);
        this.availablePool.addLast(xaStatefulHolder);
        this.poolSize.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("closing all connections of " + this);
            }
            for (XAStatefulHolder xaStatefulHolder : this.getXAResourceHolders()) {
                try {
                    xaStatefulHolder.close();
                }
                catch (Exception ex) {
                    if (!LogDebugCheck.isDebugEnabled()) continue;
                    log.log(Level.FINER, "ignoring exception while closing connection " + xaStatefulHolder, ex);
                }
            }
            if (TransactionManagerServices.isTaskSchedulerRunning()) {
                TransactionManagerServices.getTaskScheduler().cancelPoolShrinking(this);
            }
            this.stateTransitionLock.writeLock().lock();
            try {
                this.availablePool.clear();
                this.accessiblePool.clear();
                this.inaccessiblePool.clear();
                this.failed.set(false);
            }
            finally {
                this.stateTransitionLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnectionHandle(boolean recycle) throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (this.isFailed()) {
                this.reinitializePool();
            }
        }
        long remainingTimeMs = TimeUnit.SECONDS.toMillis(this.bean.getAcquisitionTimeout());
        while (true) {
            long before = MonotonicClock.currentTimeMillis();
            XAStatefulHolder xaStatefulHolder = null;
            if (recycle) {
                xaStatefulHolder = this.bean.getShareTransactionConnections() ? (XAStatefulHolder)this.getSharedXAStatefulHolder() : (XAStatefulHolder)this.getNotAccessible();
            }
            if (xaStatefulHolder == null) {
                xaStatefulHolder = (XAStatefulHolder)this.getInPool(remainingTimeMs);
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("found " + xaStatefulHolder.getState() + " connection " + xaStatefulHolder + " from " + this);
            }
            try {
                Object connectionHandle = xaStatefulHolder.getConnectionHandle();
                if (this.bean.getShareTransactionConnections()) {
                    this.putSharedXAStatefulHolder(xaStatefulHolder);
                }
                return connectionHandle;
            }
            catch (Exception ex) {
                long now;
                if (LogDebugCheck.isDebugEnabled()) {
                    log.log(Level.FINER, "connection is invalid, trying to close it", ex);
                }
                try {
                    xaStatefulHolder.close();
                    continue;
                }
                catch (Exception ex2) {
                    if (!LogDebugCheck.isDebugEnabled()) continue;
                    log.log(Level.FINER, "exception while trying to close invalid connection, ignoring it", ex2);
                    continue;
                }
                finally {
                    long waitTime;
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("removed invalid connection " + xaStatefulHolder + " from " + this);
                    }
                    if (xaStatefulHolder.getState() != XAStatefulHolder.State.CLOSED) {
                        this.stateChanged(xaStatefulHolder, xaStatefulHolder.getState(), XAStatefulHolder.State.CLOSED);
                    }
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("waiting " + this.bean.getAcquisitionInterval() + "s before trying to acquire a connection again from " + this);
                    }
                    if ((waitTime = TimeUnit.SECONDS.toMillis(this.bean.getAcquisitionInterval())) > 0L) {
                        this.waitFor(waitTime);
                    }
                }
                if ((remainingTimeMs -= (now = MonotonicClock.currentTimeMillis()) - before) > 0L) continue;
                throw new BitronixRuntimeException("cannot get valid connection from " + this + " after trying for " + this.bean.getAcquisitionTimeout() + "s", ex);
            }
            break;
        }
    }

    private synchronized void waitFor(long waitTime) {
        try {
            this.wait(waitTime);
        }
        catch (InterruptedException ex2) {
            log.log(Level.FINEST, "Waiting exception", ex2);
        }
    }

    public Object getConnectionHandle() throws Exception {
        return this.getConnectionHandle(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stateChanged(T source, XAStatefulHolder.State oldState, XAStatefulHolder.State newState) {
        this.stateTransitionLock.writeLock().lock();
        try {
            switch (newState) {
                case IN_POOL: {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("added " + source + " to the available pool");
                    }
                    this.availablePool.addFirst(source);
                    return;
                }
                case ACCESSIBLE: {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("added " + source + " to the accessible pool");
                    }
                    this.accessiblePool.add(source);
                    return;
                }
                case NOT_ACCESSIBLE: {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("added " + source + " to the inaccessible pool");
                    }
                    this.inaccessiblePool.add(source);
                    return;
                }
                case CLOSED: {
                    source.removeStateChangeEventListener(this);
                    this.poolSize.decrementAndGet();
                    return;
                }
            }
            return;
        }
        finally {
            this.stateTransitionLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stateChanging(T source, XAStatefulHolder.State currentState, XAStatefulHolder.State futureState) {
        this.stateTransitionLock.writeLock().lock();
        try {
            switch (currentState) {
                case IN_POOL: {
                    return;
                }
                case ACCESSIBLE: {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("removed " + source + " from the accessible pool");
                    }
                    this.accessiblePool.remove(source);
                    return;
                }
                case NOT_ACCESSIBLE: {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("removed " + source + " from the inaccessible pool");
                    }
                    this.inaccessiblePool.remove(source);
                    return;
                }
            }
            return;
        }
        finally {
            this.stateTransitionLock.writeLock().unlock();
        }
    }

    private T getInPool(long remainingTimeMs) throws Exception {
        if (this.inPoolSize() == 0) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("no more free connections in " + this + ", trying to grow it");
            }
            this.grow();
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("getting IN_POOL connection from " + this + ", waiting if necessary");
        }
        try {
            XAStatefulHolder xaStatefulHolder = (XAStatefulHolder)this.availablePool.pollFirst(remainingTimeMs, TimeUnit.MILLISECONDS);
            if (xaStatefulHolder == null) {
                if (TransactionManagerServices.isTransactionManagerRunning()) {
                    TransactionManagerServices.getTransactionManager().dumpTransactionContexts();
                }
                throw new BitronixRuntimeException("XA pool of resource " + this.bean.getUniqueName() + " still empty after " + this.bean.getAcquisitionTimeout() + "s wait time");
            }
            if (this.expireStatefulHolder(xaStatefulHolder, false)) {
                return this.getInPool(remainingTimeMs);
            }
            return (T)xaStatefulHolder;
        }
        catch (InterruptedException e) {
            throw new BitronixRuntimeException("Interrupted while waiting for IN_POOL connection.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getNotAccessible() {
        BitronixTransaction transaction;
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("trying to recycle a NOT_ACCESSIBLE connection of " + this);
        }
        if ((transaction = TransactionContextHelper.currentTransaction()) == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("no current transaction, no connection can be in state NOT_ACCESSIBLE when there is no global transaction context");
            }
            return null;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("current transaction GTRID is [" + currentTxGtrid + "]");
        }
        this.stateTransitionLock.readLock().lock();
        try {
            for (XAStatefulHolder xaStatefulHolder : this.inaccessiblePool) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("found a connection in NOT_ACCESSIBLE state: " + xaStatefulHolder);
                }
                if (!this.containsXAResourceHolderMatchingGtrid(xaStatefulHolder, currentTxGtrid)) continue;
                XAStatefulHolder xAStatefulHolder = xaStatefulHolder;
                return (T)xAStatefulHolder;
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("no NOT_ACCESSIBLE connection enlisted in this transaction");
            }
            Iterator iterator = null;
            return (T)iterator;
        }
        finally {
            this.stateTransitionLock.readLock().unlock();
        }
    }

    private T getSharedXAStatefulHolder() {
        XAStatefulHolder xaStatefulHolder;
        BitronixTransaction transaction = TransactionContextHelper.currentTransaction();
        if (transaction == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("no current transaction, shared connection map will not be used");
            }
            return null;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        StatefulHolderThreadLocal<T> threadLocal = this.statefulHolderTransactionMap.get(currentTxGtrid);
        if (threadLocal != null && (xaStatefulHolder = (XAStatefulHolder)threadLocal.get()) != null && xaStatefulHolder.getState() != XAStatefulHolder.State.IN_POOL && xaStatefulHolder.getState() != XAStatefulHolder.State.CLOSED) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("sharing connection " + xaStatefulHolder + " in transaction " + currentTxGtrid);
            }
            return (T)xaStatefulHolder;
        }
        return null;
    }

    private boolean containsXAResourceHolderMatchingGtrid(T xaStatefulHolder, final Uid currentTxGtrid) {
        List<XAResourceHolder<XAResourceHolder>> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer(xaResourceHolders.size() + " xa resource(s) created by connection in NOT_ACCESSIBLE state: " + xaStatefulHolder);
        }
        for (XAResourceHolder<XAResourceHolder> xaResourceHolder : xaResourceHolders) {
            class LocalVisitor
            implements XAResourceHolderStateVisitor {
                private boolean found;

                LocalVisitor() {
                }

                @Override
                public boolean visit(XAResourceHolderState xaResourceHolderState) {
                    BitronixXid bitronixXid = xaResourceHolderState.getXid();
                    Uid resourceGtrid = bitronixXid.getGlobalTransactionIdUid();
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("NOT_ACCESSIBLE xa resource GTRID: " + resourceGtrid);
                    }
                    if (currentTxGtrid.equals(resourceGtrid)) {
                        if (LogDebugCheck.isDebugEnabled()) {
                            log.finer("NOT_ACCESSIBLE xa resource's GTRID matched this transaction's GTRID, recycling it");
                        }
                        this.found = true;
                    }
                    return !this.found;
                }
            }
            LocalVisitor xaResourceHolderStateVisitor = new LocalVisitor();
            xaResourceHolder.acceptVisitorForXAResourceHolderStates(currentTxGtrid, xaResourceHolderStateVisitor);
            if (!xaResourceHolderStateVisitor.found) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grow() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            long totalPoolSize = this.totalPoolSize();
            if (totalPoolSize < (long)this.bean.getMaxPoolSize()) {
                long increment = this.bean.getAcquireIncrement();
                if (totalPoolSize + increment > (long)this.bean.getMaxPoolSize()) {
                    increment = (long)this.bean.getMaxPoolSize() - totalPoolSize;
                }
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("incrementing " + this.bean.getUniqueName() + " pool size by " + increment + " unit(s) to reach " + ((long)this.totalPoolSize() + increment) + " connection(s)");
                }
                int i = 0;
                while ((long)i < increment) {
                    this.createPooledObject(this.xaFactory);
                    ++i;
                }
            } else if (LogDebugCheck.isDebugEnabled()) {
                log.finer("pool " + this.bean.getUniqueName() + " already at max size of " + this.totalPoolSize() + " connection(s), not growing it");
            }
            if (this.totalPoolSize() < this.bean.getMinPoolSize()) {
                this.growUntilMinPoolSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("shrinking " + this);
            }
            this.expireOrCloseStatefulHolders(false);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("shrunk " + this);
            }
        }
    }

    private void expireOrCloseStatefulHolders(boolean forceClose) throws Exception {
        XAStatefulHolder xaStatefulHolder;
        int closed = 0;
        int availableSize = this.availablePool.size();
        for (int i = 0; i < availableSize && (xaStatefulHolder = (XAStatefulHolder)this.availablePool.pollFirst()) != null; ++i) {
            if (this.expireStatefulHolder(xaStatefulHolder, forceClose)) {
                ++closed;
                continue;
            }
            this.availablePool.addLast(xaStatefulHolder);
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("closed " + closed + (forceClose ? " " : " idle ") + "connection(s)");
        }
        this.growUntilMinPoolSize();
    }

    private boolean expireStatefulHolder(T xaStatefulHolder, boolean forceClose) {
        long expirationTime = Long.MAX_VALUE;
        if (this.bean.getMaxIdleTime() > 0) {
            expirationTime = xaStatefulHolder.getLastReleaseDate().getTime() + TimeUnit.SECONDS.toMillis(this.bean.getMaxIdleTime());
        }
        if (this.bean.getMaxLifeTime() > 0) {
            long endOfLife = xaStatefulHolder.getCreationDate().getTime() + TimeUnit.SECONDS.toMillis(this.bean.getMaxLifeTime());
            expirationTime = Math.min(expirationTime, endOfLife);
        }
        long now = MonotonicClock.currentTimeMillis();
        if (!forceClose && LogDebugCheck.isDebugEnabled()) {
            log.finer("checking if connection can be closed: " + xaStatefulHolder + " - closing time: " + expirationTime + ", now time: " + now);
        }
        if (expirationTime <= now || forceClose) {
            try {
                xaStatefulHolder.close();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "error closing " + xaStatefulHolder, ex);
            }
            return true;
        }
        return false;
    }

    public Date getNextShrinkDate() {
        return new Date(MonotonicClock.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.bean.getMaxIdleTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resetting " + this);
            }
            this.expireOrCloseStatefulHolders(true);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("reset " + this);
            }
        }
    }

    private void reinitializePool() {
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("resource '" + this.bean.getUniqueName() + "' is marked as failed, resetting and recovering it before trying connection acquisition");
            }
            this.close();
            this.init();
            IncrementalRecoverer.recover(this.xaResourceProducer);
        }
        catch (RecoveryException ex) {
            throw new BitronixRuntimeException("incremental recovery failed when trying to acquire a connection from failed resource '" + this.bean.getUniqueName() + "'", ex);
        }
        catch (Exception ex) {
            throw new BitronixRuntimeException("pool reset failed when trying to acquire a connection from failed resource '" + this.bean.getUniqueName() + "'", ex);
        }
    }

    public Object getXAFactory() {
        return this.xaFactory;
    }

    public List<T> getXAResourceHolders() {
        this.stateTransitionLock.readLock().lock();
        try {
            ArrayList<T> holders = new ArrayList<T>();
            holders.addAll(this.availablePool);
            holders.addAll(this.accessiblePool);
            holders.addAll(this.inaccessiblePool);
            ArrayList<T> arrayList = holders;
            return arrayList;
        }
        finally {
            this.stateTransitionLock.readLock().unlock();
        }
    }

    public String toString() {
        return "an XAPool of resource " + this.bean.getUniqueName() + " with " + this.totalPoolSize() + " connection(s) (" + this.inPoolSize() + " still available)" + (this.isFailed() ? " -failed-" : "");
    }

    public int inPoolSize() {
        return this.availablePool.size();
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public void setFailed(boolean failed) {
        this.failed.set(failed);
    }

    private void putSharedXAStatefulHolder(T xaStatefulHolder) {
        BitronixTransaction transaction = TransactionContextHelper.currentTransaction();
        if (transaction == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("no current transaction, not adding " + xaStatefulHolder + " to shared connection map");
            }
            return;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        StatefulHolderThreadLocal<T> threadLocal = this.statefulHolderTransactionMap.get(currentTxGtrid);
        if (threadLocal == null) {
            try {
                transaction.registerSynchronization(new SharedStatefulHolderCleanupSynchronization(currentTxGtrid));
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Ignoreing Exception", e);
                return;
            }
            threadLocal = new StatefulHolderThreadLocal();
            this.statefulHolderTransactionMap.put(currentTxGtrid, threadLocal);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("added shared connection mapping for " + currentTxGtrid + " holder " + xaStatefulHolder);
            }
        }
        threadLocal.set(xaStatefulHolder);
    }

    private final class SharedStatefulHolderCleanupSynchronization
    implements Synchronization {
        private final Uid gtrid;

        private SharedStatefulHolderCleanupSynchronization(Uid gtrid) {
            this.gtrid = gtrid;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            XAPool.this.statefulHolderTransactionMap.remove(this.gtrid);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("deleted shared connection mappings for " + this.gtrid);
            }
        }

        public String toString() {
            return "a SharedStatefulHolderCleanupSynchronization with GTRID [" + this.gtrid + "]";
        }
    }

    private static final class StatefulHolderThreadLocal<T extends XAStatefulHolder>
    extends ThreadLocal<T> {
        private StatefulHolderThreadLocal() {
        }
    }
}

