/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.ehcache;

import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.ehcache.EhCacheXAResourceHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAResource;

public final class EhCacheXAResourceProducer
extends ResourceBean
implements XAResourceProducer<EhCacheXAResourceHolder, EhCacheXAResourceHolder> {
    private static final Logger log = Logger.getLogger(EhCacheXAResourceProducer.class.getName());
    private static final ConcurrentMap<String, EhCacheXAResourceProducer> producers = new ConcurrentHashMap<String, EhCacheXAResourceProducer>();
    private final transient ConcurrentMap<Integer, EhCacheXAResourceHolder> xaResourceHolders = new ConcurrentHashMap<Integer, EhCacheXAResourceHolder>();
    private final transient AtomicInteger xaResourceHolderCounter = new AtomicInteger();
    private volatile transient RecoveryXAResourceHolder recoveryXAResourceHolder;

    private EhCacheXAResourceProducer() {
        this.setApplyTransactionTimeout(true);
    }

    public static void registerXAResource(String uniqueName, XAResource xaResource) {
        EhCacheXAResourceProducer xaResourceProducer = (EhCacheXAResourceProducer)producers.get(uniqueName);
        if (xaResourceProducer == null) {
            xaResourceProducer = new EhCacheXAResourceProducer();
            xaResourceProducer.setUniqueName(uniqueName);
            xaResourceProducer.addXAResource(xaResource);
            EhCacheXAResourceProducer previous = producers.putIfAbsent(uniqueName, xaResourceProducer);
            if (previous == null) {
                xaResourceProducer.init();
            } else {
                previous.addXAResource(xaResource);
            }
        } else {
            xaResourceProducer.addXAResource(xaResource);
        }
    }

    private void addXAResource(XAResource xaResource) {
        EhCacheXAResourceHolder xaResourceHolder = new EhCacheXAResourceHolder(xaResource, this);
        int key = this.xaResourceHolderCounter.incrementAndGet();
        this.xaResourceHolders.put(key, xaResourceHolder);
    }

    public static void unregisterXAResource(String uniqueName, XAResource xaResource) {
        EhCacheXAResourceProducer xaResourceProducer = (EhCacheXAResourceProducer)producers.get(uniqueName);
        if (xaResourceProducer != null) {
            boolean found = xaResourceProducer.removeXAResource(xaResource);
            if (!found) {
                log.severe("no XAResource " + xaResource + " found in XAResourceProducer with name " + uniqueName);
            }
            if (xaResourceProducer.xaResourceHolders.isEmpty()) {
                xaResourceProducer.close();
                producers.remove(uniqueName);
            }
        } else {
            log.severe("no XAResourceProducer registered with name " + uniqueName);
        }
    }

    private boolean removeXAResource(XAResource xaResource) {
        for (Map.Entry entry : this.xaResourceHolders.entrySet()) {
            Integer key = (Integer)entry.getKey();
            EhCacheXAResourceHolder xaResourceHolder = (EhCacheXAResourceHolder)entry.getValue();
            if (xaResourceHolder.getXAResource() != xaResource) continue;
            this.xaResourceHolders.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public XAResourceHolderState startRecovery() throws RecoveryException {
        if (this.recoveryXAResourceHolder != null) {
            throw new RecoveryException("recovery already in progress on " + this);
        }
        if (this.xaResourceHolders.isEmpty()) {
            throw new RecoveryException("no XAResource registered, recovery cannot be done on " + this);
        }
        this.recoveryXAResourceHolder = new RecoveryXAResourceHolder((XAResourceHolder)this.xaResourceHolders.values().iterator().next());
        return new XAResourceHolderState(this.recoveryXAResourceHolder, this);
    }

    @Override
    public void endRecovery() throws RecoveryException {
        this.recoveryXAResourceHolder = null;
    }

    @Override
    public void setFailed(boolean failed) {
    }

    @Override
    public EhCacheXAResourceHolder findXAResourceHolder(XAResource xaResource) {
        for (EhCacheXAResourceHolder xaResourceHolder : this.xaResourceHolders.values()) {
            if (xaResource != xaResourceHolder.getXAResource()) continue;
            return xaResourceHolder;
        }
        return null;
    }

    @Override
    public void init() {
        try {
            ResourceRegistrar.register(this);
        }
        catch (RecoveryException ex) {
            throw new BitronixRuntimeException("error recovering " + this, ex);
        }
    }

    @Override
    public void close() {
        this.xaResourceHolders.clear();
        this.xaResourceHolderCounter.set(0);
        ResourceRegistrar.unregister(this);
    }

    @Override
    public EhCacheXAResourceHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        throw new UnsupportedOperationException("Ehcache is not connection-oriented");
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(EhCacheXAResourceProducer.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    public String toString() {
        return "a EhCacheXAResourceProducer with uniqueName " + this.getUniqueName();
    }
}

