/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.internal.LogDebugCheck;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcClassHelper {
    private static final Logger log = Logger.getLogger(JdbcClassHelper.class.toString());
    private static final int DETECTION_TIMEOUT = 5;
    private static final Map<Class<Connection>, Integer> connectionClassVersions = new ConcurrentHashMap<Class<Connection>, Integer>();
    private static final Map<Class<? extends Connection>, Method> isValidMethods = new ConcurrentHashMap<Class<? extends Connection>, Method>();

    private JdbcClassHelper() {
    }

    public static Method getIsValidMethod(Connection connection) {
        JdbcClassHelper.detectJdbcVersion(connection);
        return isValidMethods.get(connection.getClass());
    }

    public static int detectJdbcVersion(Connection connection) {
        Class<?> connectionClass = connection.getClass();
        Integer jdbcVersionDetected = connectionClassVersions.get(connectionClass);
        if (jdbcVersionDetected != null) {
            return jdbcVersionDetected;
        }
        try {
            Method isValidMethod = connectionClass.getMethod("isValid", Integer.TYPE);
            isValidMethod.invoke((Object)connection, 5);
            jdbcVersionDetected = 4;
            isValidMethods.put(connectionClass, isValidMethod);
        }
        catch (AbstractMethodError | Exception ex) {
            log.log(Level.FINEST, "NOT JDBC 4 : " + connectionClass, ex);
            jdbcVersionDetected = 3;
        }
        connectionClassVersions.put(connectionClass, jdbcVersionDetected);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("detected JDBC connection class '" + connectionClass + "' is version " + jdbcVersionDetected + " type");
        }
        return jdbcVersionDetected;
    }
}

