/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.jdbc.ConnectionCustomizer;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.PooledConnectionProxy;
import bitronix.tm.resource.jdbc.PoolingDataSourceMBean;
import bitronix.tm.utils.ManagementRegistrar;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class PoolingDataSource
extends ResourceBean
implements DataSource,
XAResourceProducer<JdbcPooledConnection, JdbcPooledConnection>,
PoolingDataSourceMBean {
    private static final Logger log = Logger.getLogger(PoolingDataSource.class.toString());
    private final transient List<ConnectionCustomizer> connectionCustomizers = new CopyOnWriteArrayList<ConnectionCustomizer>();
    private volatile transient XAPool<JdbcPooledConnection, JdbcPooledConnection> pool;
    private volatile transient XADataSource xaDataSource;
    private volatile transient RecoveryXAResourceHolder recoveryXAResourceHolder;
    private volatile transient Connection recoveryConnectionHandle;
    private volatile transient Map<XAResource, JdbcPooledConnection> xaResourceHolderMap = new ConcurrentHashMap<XAResource, JdbcPooledConnection>();
    private volatile String testQuery;
    private volatile boolean enableJdbc4ConnectionTest;
    private volatile int connectionTestTimeout;
    private volatile int preparedStatementCacheSize = 0;
    private volatile String isolationLevel;
    private volatile String cursorHoldability;
    private volatile String localAutoCommit;
    private volatile String jmxName;

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setXaDataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public void setTestQuery(String testQuery) {
        this.testQuery = testQuery;
    }

    public boolean isEnableJdbc4ConnectionTest() {
        return this.enableJdbc4ConnectionTest;
    }

    public void setEnableJdbc4ConnectionTest(boolean enableJdbc4ConnectionTest) {
        this.enableJdbc4ConnectionTest = enableJdbc4ConnectionTest;
    }

    public int getEffectiveConnectionTestTimeout() {
        int t1 = this.getConnectionTestTimeout();
        int t2 = this.getAcquisitionTimeout();
        if (t1 > 0 && t2 > 0) {
            return Math.min(t1, t2);
        }
        return Math.max(t1, t2);
    }

    public int getConnectionTestTimeout() {
        return this.connectionTestTimeout;
    }

    public void setConnectionTestTimeout(int connectionTestTimeout) {
        this.connectionTestTimeout = connectionTestTimeout;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public String getCursorHoldability() {
        return this.cursorHoldability;
    }

    public void setCursorHoldability(String cursorHoldability) {
        this.cursorHoldability = cursorHoldability;
    }

    public String getLocalAutoCommit() {
        return this.localAutoCommit;
    }

    public void setLocalAutoCommit(String localAutoCommit) {
        this.localAutoCommit = localAutoCommit;
    }

    public void addConnectionCustomizer(ConnectionCustomizer connectionCustomizer) {
        this.connectionCustomizers.add(connectionCustomizer);
    }

    public void removeConnectionCustomizer(ConnectionCustomizer connectionCustomizer) {
        Iterator<ConnectionCustomizer> it = this.connectionCustomizers.iterator();
        while (it.hasNext()) {
            ConnectionCustomizer customizer = it.next();
            if (customizer != connectionCustomizer) continue;
            it.remove();
            return;
        }
    }

    void fireOnAcquire(Connection connection) {
        for (ConnectionCustomizer connectionCustomizer : this.connectionCustomizers) {
            try {
                connectionCustomizer.onAcquire(connection, this.getUniqueName());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "ConnectionCustomizer.onAcquire() failed for " + connectionCustomizer, ex);
            }
        }
    }

    void fireOnLease(Connection connection) {
        for (ConnectionCustomizer connectionCustomizer : this.connectionCustomizers) {
            try {
                connectionCustomizer.onLease(connection, this.getUniqueName());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "ConnectionCustomizer.onLease() failed for " + connectionCustomizer, ex);
            }
        }
    }

    void fireOnRelease(Connection connection) {
        for (ConnectionCustomizer connectionCustomizer : this.connectionCustomizers) {
            try {
                connectionCustomizer.onRelease(connection, this.getUniqueName());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "ConnectionCustomizer.onRelease() failed for " + connectionCustomizer, ex);
            }
        }
    }

    void fireOnDestroy(Connection connection) {
        for (ConnectionCustomizer connectionCustomizer : this.connectionCustomizers) {
            try {
                connectionCustomizer.onDestroy(connection, this.getUniqueName());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "ConnectionCustomizer.onDestroy() failed for " + connectionCustomizer, ex);
            }
        }
    }

    public String toString() {
        return "a PoolingDataSource containing " + this.pool;
    }

    @Override
    public XAResourceHolderState startRecovery() throws RecoveryException {
        this.init();
        if (this.recoveryConnectionHandle != null) {
            throw new RecoveryException("recovery already in progress on " + this);
        }
        try {
            this.recoveryConnectionHandle = (Connection)this.pool.getConnectionHandle(false);
            PooledConnectionProxy pooledConnection = (PooledConnectionProxy)((Object)this.recoveryConnectionHandle);
            this.recoveryXAResourceHolder = pooledConnection.getPooledConnection().createRecoveryXAResourceHolder();
            return new XAResourceHolderState(pooledConnection.getPooledConnection(), this);
        }
        catch (Exception ex) {
            throw new RecoveryException("cannot start recovery on " + this, ex);
        }
    }

    @Override
    public void endRecovery() throws RecoveryException {
        if (this.recoveryConnectionHandle == null) {
            return;
        }
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("recovery xa resource is being closed: " + this.recoveryXAResourceHolder);
            }
            this.recoveryConnectionHandle.close();
        }
        catch (Exception ex) {
            throw new RecoveryException("error ending recovery on " + this, ex);
        }
        finally {
            this.recoveryConnectionHandle = null;
            this.recoveryXAResourceHolder = null;
        }
    }

    private void buildXAPool() throws Exception {
        if (this.pool != null) {
            return;
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("building XA pool for " + this.getUniqueName() + " with " + this.getMinPoolSize() + " connection(s)");
        }
        this.pool = new XAPool<JdbcPooledConnection, JdbcPooledConnection>(this, this, this.xaDataSource);
        boolean builtXaFactory = false;
        if (this.xaDataSource == null) {
            this.xaDataSource = (XADataSource)this.pool.getXAFactory();
            builtXaFactory = true;
        }
        try {
            ResourceRegistrar.register(this);
        }
        catch (RecoveryException ex) {
            if (builtXaFactory) {
                this.xaDataSource = null;
            }
            this.pool = null;
            throw ex;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this.xaDataSource;
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.xaDataSource.getClass());
    }

    @Override
    public int getInPoolSize() {
        return this.pool.inPoolSize();
    }

    @Override
    public int getTotalPoolSize() {
        return this.pool.totalPoolSize();
    }

    @Override
    public boolean isFailed() {
        return this.pool != null ? this.pool.isFailed() : false;
    }

    @Override
    public void setFailed(boolean failed) {
        if (this.pool != null) {
            this.pool.setFailed(failed);
        }
    }

    @Override
    public JdbcPooledConnection findXAResourceHolder(XAResource xaResource) {
        return this.xaResourceHolderMap.get(xaResource);
    }

    @Override
    public synchronized void init() {
        if (this.pool != null) {
            return;
        }
        try {
            this.buildXAPool();
            this.jmxName = "bitronix.tm:type=JDBC,UniqueName=" + ManagementRegistrar.makeValidName(this.getUniqueName());
            ManagementRegistrar.register(this.jmxName, this);
        }
        catch (Exception ex) {
            throw new ResourceConfigurationException("cannot create JDBC datasource named " + this.getUniqueName(), ex);
        }
    }

    @Override
    public void close() {
        if (this.pool == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("trying to close already closed PoolingDataSource " + this.getUniqueName());
            }
            return;
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("closing " + this);
        }
        this.pool.close();
        this.pool = null;
        this.xaResourceHolderMap.clear();
        this.connectionCustomizers.clear();
        ManagementRegistrar.unregister(this.jmxName);
        this.jmxName = null;
        ResourceRegistrar.unregister(this);
    }

    @Override
    public JdbcPooledConnection createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        if (!(xaFactory instanceof XADataSource)) {
            throw new IllegalArgumentException("class '" + xaFactory.getClass().getName() + "' does not implement " + XADataSource.class.getName());
        }
        XADataSource xads = (XADataSource)xaFactory;
        JdbcPooledConnection pooledConnection = new JdbcPooledConnection(this, xads.getXAConnection());
        this.xaResourceHolderMap.put(pooledConnection.getXAResource(), pooledConnection);
        return pooledConnection;
    }

    @Override
    public void reset() throws Exception {
        this.pool.reset();
    }

    @Override
    public Reference getReference() throws NamingException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("creating new JNDI reference of " + this);
        }
        return new Reference(PoolingDataSource.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    public void unregister(JdbcPooledConnection xaResourceHolder) {
        this.xaResourceHolderMap.remove(xaResourceHolder.getXAResource());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isDisabled()) {
            throw new SQLException("JDBC connection pool '" + this.getUniqueName() + "' is disabled, cannot get a connection from it");
        }
        this.init();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("acquiring connection from " + this);
        }
        if (this.pool == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("pool is closed, returning null connection");
            }
            return null;
        }
        try {
            Connection conn = (Connection)this.pool.getConnectionHandle();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("acquired connection from " + this);
            }
            return conn;
        }
        catch (Exception ex) {
            throw new SQLException("unable to get a connection from pool of " + this, ex);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("JDBC connections are pooled, username and password ignored");
        }
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.xaDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.xaDataSource.setLoginTimeout(seconds);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.xaDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xaDataSource.setLogWriter(out);
    }
}

