/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class CallableStatementJavaProxy
extends JavaProxyBase<CallableStatement> {
    private static final Map<String, Method> selfMethodMap = CallableStatementJavaProxy.createMethodMap(CallableStatementJavaProxy.class);
    private JdbcPooledConnection jdbcPooledConnection;

    public CallableStatementJavaProxy() {
    }

    public CallableStatementJavaProxy(JdbcPooledConnection jdbcPooledConnection, CallableStatement statement) {
        this.initialize(jdbcPooledConnection, statement);
    }

    private void initialize(JdbcPooledConnection jdbcPooledConnection, CallableStatement statement) {
        this.proxy = this;
        this.jdbcPooledConnection = jdbcPooledConnection;
        this.delegate = statement;
    }

    public void close() throws SQLException {
        if (this.delegate == null) {
            return;
        }
        this.jdbcPooledConnection.unregisterUncachedStatement((Statement)this.delegate);
        ((CallableStatement)this.delegate).close();
    }

    public ResultSet executeQuery() throws SQLException {
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), ((CallableStatement)this.delegate).executeQuery());
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), ((CallableStatement)this.delegate).executeQuery(sql));
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return JdbcProxyFactory.INSTANCE.getProxyResultSet((Statement)this.getProxy(), ((CallableStatement)this.delegate).getGeneratedKeys());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(((CallableStatement)this.delegate).getClass())) {
            return (T)this.delegate;
        }
        if (this.isWrapperFor(iface)) {
            return CallableStatementJavaProxy.unwrap(this.delegate, iface);
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(((CallableStatement)this.delegate).getClass()) || CallableStatementJavaProxy.isWrapperFor(this.delegate, iface);
    }

    @Override
    protected Map<String, Method> getMethodMap() {
        return selfMethodMap;
    }
}

