/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.PooledConnectionProxy;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.resource.jdbc.proxy.CallableStatementJavaProxy;
import bitronix.tm.resource.jdbc.proxy.ConnectionJavaProxy;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import bitronix.tm.resource.jdbc.proxy.LrcConnectionJavaProxy;
import bitronix.tm.resource.jdbc.proxy.LrcXAConnectionJavaProxy;
import bitronix.tm.resource.jdbc.proxy.PreparedStatementJavaProxy;
import bitronix.tm.resource.jdbc.proxy.ResultSetJavaProxy;
import bitronix.tm.resource.jdbc.proxy.StatementJavaProxy;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import javax.sql.XAConnection;

public class JdbcJavaProxyFactory
implements JdbcProxyFactory {
    private final ProxyFactory<Connection> proxyConnectionFactory = this.createProxyConnectionFactory();
    private final ProxyFactory<XAConnection> proxyXAConnectionFactory = this.createProxyXAConnectionFactory();
    private final ProxyFactory<Statement> proxyStatementFactory = this.createProxyStatementFactory();
    private final ProxyFactory<CallableStatement> proxyCallableStatementFactory = this.createProxyCallableStatementFactory();
    private final ProxyFactory<PreparedStatement> proxyPreparedStatementFactory = this.createProxyPreparedStatementFactory();
    private final ProxyFactory<ResultSet> proxyResultSetFactory = this.createProxyResultSetFactory();

    private ProxyFactory<Connection> createProxyConnectionFactory() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(Connection.class);
        interfaces.add(PooledConnectionProxy.class);
        return new ProxyFactory<Connection>(interfaces.toArray(new Class[0]));
    }

    private ProxyFactory<XAConnection> createProxyXAConnectionFactory() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(Connection.class);
        interfaces.add(XAConnection.class);
        return new ProxyFactory<XAConnection>(interfaces.toArray(new Class[0]));
    }

    private ProxyFactory<Statement> createProxyStatementFactory() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(Statement.class);
        return new ProxyFactory<Statement>(interfaces.toArray(new Class[0]));
    }

    private ProxyFactory<CallableStatement> createProxyCallableStatementFactory() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(CallableStatement.class);
        return new ProxyFactory<CallableStatement>(interfaces.toArray(new Class[0]));
    }

    private ProxyFactory<PreparedStatement> createProxyPreparedStatementFactory() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(PreparedStatement.class);
        return new ProxyFactory<PreparedStatement>(interfaces.toArray(new Class[0]));
    }

    private ProxyFactory<ResultSet> createProxyResultSetFactory() {
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(ResultSet.class);
        return new ProxyFactory<ResultSet>(interfaces.toArray(new Class[0]));
    }

    @Override
    public Connection getProxyConnection(JdbcPooledConnection jdbcPooledConnection, Connection connection) {
        try {
            ConnectionJavaProxy jdbcConnectionProxy = new ConnectionJavaProxy(jdbcPooledConnection, connection);
            return this.proxyConnectionFactory.getConstructor().newInstance(jdbcConnectionProxy);
        }
        catch (Exception e) {
            throw new BitronixRuntimeException(e);
        }
    }

    @Override
    public Statement getProxyStatement(JdbcPooledConnection jdbcPooledConnection, Statement statement) {
        try {
            StatementJavaProxy jdbcStatementProxy = new StatementJavaProxy(jdbcPooledConnection, statement);
            return this.proxyStatementFactory.getConstructor().newInstance(jdbcStatementProxy);
        }
        catch (Exception e) {
            throw new BitronixRuntimeException(e);
        }
    }

    @Override
    public CallableStatement getProxyCallableStatement(JdbcPooledConnection jdbcPooledConnection, CallableStatement statement) {
        try {
            CallableStatementJavaProxy jdbcStatementProxy = new CallableStatementJavaProxy(jdbcPooledConnection, statement);
            return this.proxyCallableStatementFactory.getConstructor().newInstance(jdbcStatementProxy);
        }
        catch (Exception e) {
            throw new BitronixRuntimeException(e);
        }
    }

    @Override
    public PreparedStatement getProxyPreparedStatement(JdbcPooledConnection jdbcPooledConnection, PreparedStatement statement, LruStatementCache.CacheKey cacheKey) {
        try {
            PreparedStatementJavaProxy jdbcStatementProxy = new PreparedStatementJavaProxy(jdbcPooledConnection, statement, cacheKey);
            return this.proxyPreparedStatementFactory.getConstructor().newInstance(jdbcStatementProxy);
        }
        catch (Exception e) {
            throw new BitronixRuntimeException(e);
        }
    }

    @Override
    public ResultSet getProxyResultSet(Statement statement, ResultSet resultSet) {
        try {
            ResultSetJavaProxy jdbcResultSetProxy = new ResultSetJavaProxy(statement, resultSet);
            return this.proxyResultSetFactory.getConstructor().newInstance(jdbcResultSetProxy);
        }
        catch (Exception e) {
            throw new BitronixRuntimeException(e);
        }
    }

    @Override
    public XAConnection getProxyXaConnection(Connection connection) {
        try {
            LrcXAConnectionJavaProxy jdbcLrcXaConnectionProxy = new LrcXAConnectionJavaProxy(connection);
            return this.proxyXAConnectionFactory.getConstructor().newInstance(jdbcLrcXaConnectionProxy);
        }
        catch (Exception e) {
            throw new BitronixRuntimeException(e);
        }
    }

    @Override
    public Connection getProxyConnection(LrcXAResource xaResource, Connection connection) {
        try {
            LrcConnectionJavaProxy lrcConnectionJavaProxy = new LrcConnectionJavaProxy(xaResource, connection);
            return this.proxyConnectionFactory.getConstructor().newInstance(lrcConnectionJavaProxy);
        }
        catch (Exception e) {
            throw new BitronixRuntimeException(e);
        }
    }

    public static class ProxyFactory<T> {
        private final Class<?>[] interfaces;
        private Reference<Constructor<T>> ctorRef;

        public ProxyFactory(Class<?>[] interfaces) {
            this.interfaces = interfaces;
        }

        public T newInstance(InvocationHandler handler) {
            if (handler == null) {
                throw new NullPointerException();
            }
            try {
                return this.getConstructor().newInstance(handler);
            }
            catch (Exception e) {
                throw new InternalError(e.toString(), e);
            }
        }

        private synchronized Constructor<T> getConstructor() {
            Constructor<Object> ctor;
            Constructor<T> constructor = ctor = this.ctorRef == null ? null : this.ctorRef.get();
            if (ctor == null) {
                try {
                    ctor = Proxy.getProxyClass(this.getClass().getClassLoader(), this.interfaces).getConstructor(InvocationHandler.class);
                }
                catch (NoSuchMethodException e) {
                    throw new InternalError(e.toString(), e);
                }
                this.ctorRef = new SoftReference<Constructor<Constructor<T>>>(ctor);
            }
            return ctor;
        }
    }
}

