/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.utils.ClassLoaderUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.XAConnection;

public interface JdbcProxyFactory {
    public static final JdbcProxyFactory INSTANCE = Initializer.initialize();

    public Connection getProxyConnection(JdbcPooledConnection var1, Connection var2);

    public Statement getProxyStatement(JdbcPooledConnection var1, Statement var2);

    public CallableStatement getProxyCallableStatement(JdbcPooledConnection var1, CallableStatement var2);

    public PreparedStatement getProxyPreparedStatement(JdbcPooledConnection var1, PreparedStatement var2, LruStatementCache.CacheKey var3);

    public ResultSet getProxyResultSet(Statement var1, ResultSet var2);

    public XAConnection getProxyXaConnection(Connection var1);

    public Connection getProxyConnection(LrcXAResource var1, Connection var2);

    public static class Initializer {
        private Initializer() {
        }

        private static JdbcProxyFactory initialize() {
            try {
                String jdbcProxyFactoryClass = TransactionManagerServices.getConfiguration().getJdbcProxyFactoryClass();
                if ("auto".equals(jdbcProxyFactoryClass)) {
                    try {
                        ClassLoaderUtils.loadClass("javassist.CtClass");
                        jdbcProxyFactoryClass = "bitronix.tm.resource.jdbc.proxy.JdbcJavassistProxyFactory";
                    }
                    catch (ClassNotFoundException cnfe) {
                        try {
                            ClassLoaderUtils.loadClass("net.sf.cglib.proxy.Enhancer");
                            jdbcProxyFactoryClass = "bitronix.tm.resource.jdbc.proxy.JdbcCglibProxyFactory";
                        }
                        catch (ClassNotFoundException cnfe2) {
                            jdbcProxyFactoryClass = "bitronix.tm.resource.jdbc.proxy.JdbcJavaProxyFactory";
                        }
                    }
                }
                Class proxyFactoryClass = ClassLoaderUtils.loadClass(jdbcProxyFactoryClass);
                return (JdbcProxyFactory)proxyFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new BitronixRuntimeException("error initializing JdbcProxyFactory", ex);
            }
        }
    }
}

