/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Map;

public class LrcConnectionJavaProxy
extends JavaProxyBase<Connection> {
    private static final Map<String, Method> selfMethodMap = LrcConnectionJavaProxy.createMethodMap(LrcConnectionJavaProxy.class);
    private final LrcXAResource xaResource;

    public LrcConnectionJavaProxy(LrcXAResource xaResource, Connection connection) {
        this.delegate = connection;
        this.xaResource = xaResource;
    }

    public String toString() {
        return "a JDBC LrcConnectionJavaProxy on " + this.delegate;
    }

    public void close() throws SQLException {
        if (this.delegate != null) {
            ((Connection)this.delegate).close();
        }
        this.delegate = null;
    }

    public boolean isClosed() {
        return this.delegate == null;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.xaResource.getState() != 0 && autoCommit) {
            throw new SQLException("XA transaction started, cannot enable autocommit mode");
        }
        ((Connection)this.delegate).setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        if (this.xaResource.getState() != 0) {
            throw new SQLException("XA transaction started, cannot call commit directly on connection");
        }
        ((Connection)this.delegate).commit();
    }

    public void rollback() throws SQLException {
        if (this.xaResource.getState() != 0) {
            throw new SQLException("XA transaction started, cannot call rollback directly on connection");
        }
        ((Connection)this.delegate).rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.xaResource.getState() != 0) {
            throw new SQLException("XA transaction started, cannot call rollback directly on connection");
        }
        ((Connection)this.delegate).rollback(savepoint);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(((Connection)this.delegate).getClass())) {
            return (T)this.delegate;
        }
        if (this.isWrapperFor(iface)) {
            return LrcConnectionJavaProxy.unwrap(this.delegate, iface);
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(((Connection)this.delegate).getClass()) || LrcConnectionJavaProxy.isWrapperFor(this.delegate, iface);
    }

    @Override
    protected Map<String, Method> getMethodMap() {
        return selfMethodMap;
    }
}

