/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import bitronix.tm.resource.jdbc.proxy.JdbcJavaProxyFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAResource;

public class LrcXAConnectionJavaProxy
extends JavaProxyBase<Connection> {
    private static final Logger log = Logger.getLogger(LrcXAConnectionJavaProxy.class.toString());
    private static final Map<String, Method> selfMethodMap = LrcXAConnectionJavaProxy.createMethodMap(LrcXAConnectionJavaProxy.class);
    private final LrcXAResource xaResource;
    private final List<ConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();

    public LrcXAConnectionJavaProxy(Connection connection) {
        this.xaResource = new LrcXAResource(connection);
        this.delegate = new JdbcJavaProxyFactory().getProxyConnection(this.xaResource, connection);
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }

    public void close() throws SQLException {
        ((Connection)this.delegate).close();
        this.fireCloseEvent();
    }

    private void fireCloseEvent() {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("notifying " + this.connectionEventListeners.size() + " connectionEventListeners(s) about closing of " + this);
        }
        for (ConnectionEventListener connectionEventListener : this.connectionEventListeners) {
            connectionEventListener.connectionClosed(new ConnectionEvent((PooledConnection)this.delegate));
        }
    }

    public Connection getConnection() {
        return (Connection)this.delegate;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    public int hashCode() {
        return ((Connection)this.delegate).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LrcXAConnectionJavaProxy)) {
            return false;
        }
        LrcXAConnectionJavaProxy other = (LrcXAConnectionJavaProxy)obj;
        return ((Connection)this.delegate).equals(other.delegate);
    }

    public String toString() {
        return "a JDBC LrcXAConnection on " + this.delegate;
    }

    @Override
    protected Map<String, Method> getMethodMap() {
        return selfMethodMap;
    }
}

