/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.internal.BitronixRollbackSystemException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.common.AbstractXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jms.JmsPooledConnection;
import bitronix.tm.resource.jms.MessageConsumerWrapper;
import bitronix.tm.resource.jms.MessageProducerConsumerKey;
import bitronix.tm.resource.jms.MessageProducerWrapper;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import bitronix.tm.resource.jms.TopicSubscriberWrapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionRolledBackException;
import javax.jms.XASession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;

public class DualSessionWrapper
extends AbstractXAResourceHolder<DualSessionWrapper>
implements Session,
StateChangeListener<DualSessionWrapper> {
    private static final Logger log = Logger.getLogger(DualSessionWrapper.class.toString());
    private static final String CREATING_IT = ", creating it";
    private static final String FOUND_CONSUMER_ON = "found consumer based on ";
    private final JmsPooledConnection pooledConnection;
    private final boolean transacted;
    private final int acknowledgeMode;
    private final Map<MessageProducerConsumerKey, MessageProducer> messageProducers = new HashMap<MessageProducerConsumerKey, MessageProducer>();
    private final Map<MessageProducerConsumerKey, MessageConsumer> messageConsumers = new HashMap<MessageProducerConsumerKey, MessageConsumer>();
    private final Map<MessageProducerConsumerKey, TopicSubscriberWrapper> topicSubscribers = new HashMap<MessageProducerConsumerKey, TopicSubscriberWrapper>();
    private XASession xaSession;
    private Session session;
    private XAResource xaResource;
    private MessageListener listener;

    public DualSessionWrapper(JmsPooledConnection pooledConnection, boolean transacted, int acknowledgeMode) {
        this.pooledConnection = pooledConnection;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("getting session handle from " + pooledConnection);
        }
        this.setState(XAStatefulHolder.State.ACCESSIBLE);
        this.addStateChangeEventListener(this);
    }

    public String toString() {
        return "a DualSessionWrapper in state " + this.getState() + " of " + this.pooledConnection;
    }

    @Override
    public void stateChanged(DualSessionWrapper source, XAStatefulHolder.State oldState, XAStatefulHolder.State newState) {
        if (newState == XAStatefulHolder.State.IN_POOL) {
            this.setState(XAStatefulHolder.State.CLOSED);
        } else if (newState == XAStatefulHolder.State.CLOSED) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("session state changing to CLOSED, cleaning it up: " + this);
            }
            if (this.xaSession != null) {
                try {
                    this.xaSession.close();
                }
                catch (JMSException ex) {
                    log.log(Level.SEVERE, "error closing XA session", ex);
                }
                this.xaSession = null;
                this.xaResource = null;
            }
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (JMSException ex) {
                    log.log(Level.SEVERE, "error closing session", ex);
                }
                this.session = null;
            }
            for (Map.Entry<MessageProducerConsumerKey, MessageProducer> entry : this.messageProducers.entrySet()) {
                MessageProducerWrapper messageProducerWrapper = (MessageProducerWrapper)entry.getValue();
                try {
                    messageProducerWrapper.close();
                }
                catch (JMSException ex) {
                    log.log(Level.SEVERE, "error closing message producer", ex);
                }
            }
            this.messageProducers.clear();
            for (Map.Entry<MessageProducerConsumerKey, MessageProducer> entry : this.messageConsumers.entrySet()) {
                MessageConsumerWrapper messageConsumerWrapper = (MessageConsumerWrapper)entry.getValue();
                try {
                    messageConsumerWrapper.close();
                }
                catch (JMSException ex) {
                    log.log(Level.SEVERE, "error closing message consumer", ex);
                }
            }
            this.messageConsumers.clear();
        }
    }

    @Override
    public void stateChanging(DualSessionWrapper source, XAStatefulHolder.State currentState, XAStatefulHolder.State futureState) {
    }

    @Override
    public XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public ResourceBean getResourceBean() {
        return this.getPoolingConnectionFactory();
    }

    public PoolingConnectionFactory getPoolingConnectionFactory() {
        return this.pooledConnection.getPoolingConnectionFactory();
    }

    @Override
    public List<DualSessionWrapper> getXAResourceHolders() {
        return Collections.singletonList(this);
    }

    @Override
    public Object getConnectionHandle() throws Exception {
        return null;
    }

    @Override
    public void close() throws JMSException {
        if (this.getState() != XAStatefulHolder.State.ACCESSIBLE) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("not closing already closed " + this);
            }
            return;
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("closing " + this);
        }
        try {
            TransactionContextHelper.delistFromCurrentTransaction(this);
        }
        catch (BitronixRollbackSystemException ex) {
            throw (JMSException)new TransactionRolledBackException("unilateral rollback of " + this).initCause((Throwable)((Object)ex));
        }
        catch (SystemException ex) {
            throw (JMSException)new JMSException("error delisting " + this).initCause((Throwable)ex);
        }
        finally {
            try {
                TransactionContextHelper.requeue(this, this.pooledConnection.getPoolingConnectionFactory());
            }
            catch (BitronixSystemException ex) {
                throw (JMSException)new JMSException("error requeuing " + this).initCause((Throwable)((Object)ex));
            }
        }
    }

    @Override
    public Date getLastReleaseDate() {
        return null;
    }

    public DualSessionWrapper getXAResourceHolderForXaResource(XAResource xaResource) {
        if (xaResource == this.xaResource) {
            return this;
        }
        return null;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getSession().createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.getSession().createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            return true;
        }
        return this.getSession().getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            return 0;
        }
        return this.getSession().getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            throw new TransactionInProgressException("cannot commit a resource enlisted in a global transaction");
        }
        this.getSession().commit();
    }

    public void rollback() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            throw new TransactionInProgressException("cannot rollback a resource enlisted in a global transaction");
        }
        this.getSession().rollback();
    }

    public void recover() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            throw new TransactionInProgressException("cannot recover a resource enlisted in a global transaction");
        }
        this.getSession().recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.getState() == XAStatefulHolder.State.CLOSED) {
            throw new IllegalStateException("session handle is closed");
        }
        if (this.session != null) {
            this.session.setMessageListener(listener);
        }
        if (this.xaSession != null) {
            this.xaSession.setMessageListener(listener);
        }
        this.listener = listener;
    }

    public void run() {
        try {
            Session internalSession = this.getSession(true);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("running XA session " + internalSession);
            }
            internalSession.run();
        }
        catch (JMSException ex) {
            log.log(Level.SEVERE, "error getting session", ex);
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        MessageProducerWrapper messageProducer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking for producer based on " + key);
        }
        if ((messageProducer = (MessageProducerWrapper)this.messageProducers.get(key)) == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("found no producer based on " + key + CREATING_IT);
            }
            messageProducer = new MessageProducerWrapper(this.getSession().createProducer(destination), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("caching producer via key " + key);
                }
                this.messageProducers.put(key, messageProducer);
            }
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer("found producer based on " + key + ", recycling it: " + messageProducer);
        }
        return messageProducer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumerWrapper messageConsumer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking for consumer based on " + key);
        }
        if ((messageConsumer = (MessageConsumerWrapper)this.messageConsumers.get(key)) == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("found no consumer based on " + key + CREATING_IT);
            }
            messageConsumer = new MessageConsumerWrapper(this.getSession().createConsumer(destination), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("caching consumer via key " + key);
                }
                this.messageConsumers.put(key, messageConsumer);
            }
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer(FOUND_CONSUMER_ON + key + ", recycling it: " + messageConsumer);
        }
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        MessageConsumerWrapper messageConsumer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination, messageSelector);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking for consumer based on " + key);
        }
        if ((messageConsumer = (MessageConsumerWrapper)this.messageConsumers.get(key)) == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("found no consumer based on " + key + CREATING_IT);
            }
            messageConsumer = new MessageConsumerWrapper(this.getSession().createConsumer(destination, messageSelector), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("caching consumer via key " + key);
                }
                this.messageConsumers.put(key, messageConsumer);
            }
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer(FOUND_CONSUMER_ON + key + ", recycling it: " + messageConsumer);
        }
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        MessageConsumerWrapper messageConsumer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination, messageSelector, noLocal);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking for consumer based on " + key);
        }
        if ((messageConsumer = (MessageConsumerWrapper)this.messageConsumers.get(key)) == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("found no consumer based on " + key + CREATING_IT);
            }
            messageConsumer = new MessageConsumerWrapper(this.getSession().createConsumer(destination, messageSelector, noLocal), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("caching consumer via key " + key);
                }
                this.messageConsumers.put(key, messageConsumer);
            }
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer(FOUND_CONSUMER_ON + key + ", recycling it: " + messageConsumer);
        }
        return messageConsumer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.getSession().createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.getSession().createTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TopicSubscriberWrapper topicSubscriber;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey((Destination)topic);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking for durable subscriber based on " + key);
        }
        if ((topicSubscriber = this.topicSubscribers.get(key)) == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("found no durable subscriber based on " + key + CREATING_IT);
            }
            topicSubscriber = new TopicSubscriberWrapper(this.getSession().createDurableSubscriber(topic, name), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("caching durable subscriber via key " + key);
                }
                this.topicSubscribers.put(key, topicSubscriber);
            }
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer("found durable subscriber based on " + key + ", recycling it: " + topicSubscriber);
        }
        return topicSubscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriberWrapper topicSubscriber;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey((Destination)topic, messageSelector, noLocal);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("looking for durable subscriber based on " + key);
        }
        if ((topicSubscriber = this.topicSubscribers.get(key)) == null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("found no durable subscriber based on " + key + CREATING_IT);
            }
            topicSubscriber = new TopicSubscriberWrapper(this.getSession().createDurableSubscriber(topic, name, messageSelector, noLocal), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("caching durable subscriber via key " + key);
                }
                this.topicSubscribers.put(key, topicSubscriber);
            }
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer("found durable subscriber based on " + key + ", recycling it: " + topicSubscriber);
        }
        return topicSubscriber;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.enlistResource();
        return this.getSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.enlistResource();
        return this.getSession().createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.getSession().unsubscribe(name);
    }

    public Session getSession() throws JMSException {
        return this.getSession(false);
    }

    public Session getSession(boolean forceXa) throws JMSException {
        if (this.getState() == XAStatefulHolder.State.CLOSED) {
            throw new IllegalStateException("session handle is closed");
        }
        if (forceXa) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("choosing XA session (forced)");
            }
            return this.createXASession();
        }
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        if (currentTransaction != null) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("choosing XA session");
            }
            return this.createXASession();
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("choosing non-XA session");
        }
        return this.createNonXASession();
    }

    private Session createXASession() throws JMSException {
        if (this.xaSession == null) {
            this.xaSession = this.pooledConnection.getXAConnection().createXASession();
            if (this.listener != null) {
                this.xaSession.setMessageListener(this.listener);
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("get XA session registered message listener: " + this.listener);
                }
            }
            this.xaResource = this.xaSession.getXAResource();
        }
        return this.xaSession.getSession();
    }

    private Session createNonXASession() throws JMSException {
        if (this.session == null) {
            this.session = this.pooledConnection.getXAConnection().createSession(this.transacted, this.acknowledgeMode);
            if (this.listener != null) {
                this.session.setMessageListener(this.listener);
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("get non-XA session registered message listener: " + this.listener);
                }
            }
        }
        return this.session;
    }

    protected void enlistResource() throws JMSException {
        PoolingConnectionFactory poolingConnectionFactory = this.pooledConnection.getPoolingConnectionFactory();
        if (poolingConnectionFactory.getAutomaticEnlistingEnabled()) {
            this.getSession();
            try {
                TransactionContextHelper.enlistInCurrentTransaction(this);
            }
            catch (RollbackException | SystemException ex) {
                throw (JMSException)new JMSException("error enlisting " + this).initCause(ex);
            }
        }
    }
}

