/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.resource.common.AbstractXAStatefulHolder;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.JmsConnectionHandle;
import bitronix.tm.resource.jms.JmsPooledConnectionMBean;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import bitronix.tm.resource.jms.lrc.LrcXAConnectionFactory;
import bitronix.tm.utils.ManagementRegistrar;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Scheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class JmsPooledConnection
extends AbstractXAStatefulHolder<JmsPooledConnection>
implements JmsPooledConnectionMBean {
    private static final Logger log = Logger.getLogger(JmsPooledConnection.class.toString());
    private static final String EMULATE = "emulating XA for resource ";
    private final PoolingConnectionFactory poolingConnectionFactory;
    private final Set<DualSessionWrapper> sessions = Collections.synchronizedSet(new HashSet());
    private final String jmxName;
    private volatile XAConnection xaConnection;
    private volatile Date acquisitionDate;
    private volatile Date lastReleaseDate;

    protected JmsPooledConnection(PoolingConnectionFactory poolingConnectionFactory, XAConnection connection) {
        this.poolingConnectionFactory = poolingConnectionFactory;
        this.xaConnection = connection;
        this.lastReleaseDate = new Date(MonotonicClock.currentTimeMillis());
        this.addStateChangeEventListener(new JmsPooledConnectionStateChangeListener());
        if (LrcXAConnectionFactory.class.getName().equals(poolingConnectionFactory.getClassName())) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer(EMULATE + poolingConnectionFactory.getUniqueName() + " - changing twoPcOrderingPosition to ALWAYS_LAST_POSITION");
            }
            poolingConnectionFactory.setTwoPcOrderingPosition(Scheduler.ALWAYS_LAST_POSITION);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer(EMULATE + poolingConnectionFactory.getUniqueName() + " - changing deferConnectionRelease to true");
            }
            poolingConnectionFactory.setDeferConnectionRelease(true);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer(EMULATE + poolingConnectionFactory.getUniqueName() + " - changing useTmJoin to true");
            }
            poolingConnectionFactory.setUseTmJoin(true);
        }
        this.jmxName = "bitronix.tm:type=JMS,UniqueName=" + ManagementRegistrar.makeValidName(poolingConnectionFactory.getUniqueName()) + ",Id=" + poolingConnectionFactory.incCreatedResourcesCounter();
        ManagementRegistrar.register(this.jmxName, this);
    }

    public XAConnection getXAConnection() {
        return this.xaConnection;
    }

    public PoolingConnectionFactory getPoolingConnectionFactory() {
        return this.poolingConnectionFactory;
    }

    public synchronized RecoveryXAResourceHolder createRecoveryXAResourceHolder() throws JMSException {
        DualSessionWrapper dualSessionWrapper = new DualSessionWrapper(this, false, 0);
        dualSessionWrapper.getSession(true);
        return new RecoveryXAResourceHolder(dualSessionWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DualSessionWrapper> getXAResourceHolders() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            return new ArrayList<DualSessionWrapper>(this.sessions);
        }
    }

    @Override
    public Object getConnectionHandle() throws Exception {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("getting connection handle from " + this);
        }
        XAStatefulHolder.State oldState = this.getState();
        this.setState(XAStatefulHolder.State.ACCESSIBLE);
        if (oldState == XAStatefulHolder.State.IN_POOL) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("connection " + this.xaConnection + " was in state IN_POOL, testing it");
            }
            this.testXAConnection();
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer("connection " + this.xaConnection + " was in state " + oldState + ", no need to test it");
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("got connection handle from " + this);
        }
        return new JmsConnectionHandle(this, this.xaConnection);
    }

    @Override
    public synchronized void close() throws JMSException {
        if (this.xaConnection != null) {
            this.poolingConnectionFactory.unregister(this);
            this.setState(XAStatefulHolder.State.CLOSED);
            try {
                this.xaConnection.close();
            }
            finally {
                this.xaConnection = null;
            }
        }
    }

    @Override
    public Date getLastReleaseDate() {
        return this.lastReleaseDate;
    }

    private void testXAConnection() throws JMSException {
        if (!this.poolingConnectionFactory.getTestConnections()) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("not testing connection of " + this);
            }
            return;
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("testing connection of " + this);
        }
        try (XASession xaSession = this.xaConnection.createXASession();){
            TemporaryQueue tq = xaSession.createTemporaryQueue();
            tq.delete();
        }
    }

    protected void release() throws JMSException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("releasing to pool " + this);
        }
        this.closePendingSessions();
        try {
            TransactionContextHelper.requeue(this, this.poolingConnectionFactory);
        }
        catch (BitronixSystemException ex) {
            throw (JMSException)new JMSException("error requeueing " + this).initCause((Throwable)((Object)ex));
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("released to pool " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePendingSessions() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            for (DualSessionWrapper dualSessionWrapper : this.sessions) {
                if (dualSessionWrapper.getState() != XAStatefulHolder.State.ACCESSIBLE) continue;
                try {
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("trying to close pending session " + dualSessionWrapper);
                    }
                    dualSessionWrapper.close();
                }
                catch (JMSException ex) {
                    log.log(Level.WARNING, "error closing pending session " + dualSessionWrapper, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createSession(boolean transacted, int acknowledgeMode) {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            DualSessionWrapper sessionHandle = this.getNotAccessibleSession();
            if (sessionHandle == null) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("no session handle found in NOT_ACCESSIBLE state, creating new session");
                }
                sessionHandle = new DualSessionWrapper(this, transacted, acknowledgeMode);
                sessionHandle.addStateChangeEventListener(new JmsConnectionHandleStateChangeListener());
                this.sessions.add(sessionHandle);
            } else {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("found session handle in NOT_ACCESSIBLE state, recycling it: " + sessionHandle);
                }
                sessionHandle.setState(XAStatefulHolder.State.ACCESSIBLE);
            }
            return sessionHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DualSessionWrapper getNotAccessibleSession() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer(this.sessions.size() + " session(s) open from " + this);
            }
            for (DualSessionWrapper sessionHandle : this.sessions) {
                if (sessionHandle.getState() != XAStatefulHolder.State.NOT_ACCESSIBLE) continue;
                return sessionHandle;
            }
            return null;
        }
    }

    public String toString() {
        return "a JmsPooledConnection of pool " + this.poolingConnectionFactory.getUniqueName() + " in state " + this.getState() + " with underlying connection " + this.xaConnection;
    }

    @Override
    public String getStateDescription() {
        return this.getState().toString();
    }

    @Override
    public Date getAcquisitionDate() {
        return this.acquisitionDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getTransactionGtridsCurrentlyHoldingThis() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            HashSet<String> result = new HashSet<String>();
            for (DualSessionWrapper dsw : this.sessions) {
                result.addAll(dsw.getXAResourceHolderStateGtrids());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DualSessionWrapper getXAResourceHolderForXaResource(XAResource xaResource) {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            for (DualSessionWrapper xaResourceHolder : this.sessions) {
                if (xaResourceHolder.getXAResource() != xaResource) continue;
                return xaResourceHolder;
            }
            return null;
        }
    }

    private final class JmsConnectionHandleStateChangeListener
    implements StateChangeListener<DualSessionWrapper> {
        private JmsConnectionHandleStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(DualSessionWrapper source, XAStatefulHolder.State oldState, XAStatefulHolder.State newState) {
            if (newState == XAStatefulHolder.State.CLOSED) {
                Set<DualSessionWrapper> set = JmsPooledConnection.this.sessions;
                synchronized (set) {
                    JmsPooledConnection.this.sessions.remove(source);
                    if (LogDebugCheck.isDebugEnabled()) {
                        log.finer("DualSessionWrapper has been closed, " + JmsPooledConnection.this.sessions.size() + " session(s) left open in pooled connection");
                    }
                }
            }
        }

        @Override
        public void stateChanging(DualSessionWrapper source, XAStatefulHolder.State currentState, XAStatefulHolder.State futureState) {
        }
    }

    private final class JmsPooledConnectionStateChangeListener
    implements StateChangeListener<JmsPooledConnection> {
        private JmsPooledConnectionStateChangeListener() {
        }

        @Override
        public void stateChanged(JmsPooledConnection source, XAStatefulHolder.State oldState, XAStatefulHolder.State newState) {
            if (newState == XAStatefulHolder.State.IN_POOL) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("requeued JMS connection of " + JmsPooledConnection.this.poolingConnectionFactory);
                }
                JmsPooledConnection.this.lastReleaseDate = new Date(MonotonicClock.currentTimeMillis());
            }
            if (oldState == XAStatefulHolder.State.IN_POOL && newState == XAStatefulHolder.State.ACCESSIBLE) {
                JmsPooledConnection.this.acquisitionDate = new Date(MonotonicClock.currentTimeMillis());
            }
            if (newState == XAStatefulHolder.State.CLOSED) {
                ManagementRegistrar.unregister(JmsPooledConnection.this.jmxName);
            }
        }

        @Override
        public void stateChanging(JmsPooledConnection source, XAStatefulHolder.State currentState, XAStatefulHolder.State futureState) {
        }
    }
}

