/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;
import java.util.logging.Logger;

public class RecoveryTask
extends Task {
    private static final Logger log = Logger.getLogger(RecoveryTask.class.toString());
    private final Recoverer recoverer;

    public RecoveryTask(Recoverer recoverer, Date executionTime, TaskScheduler scheduler) {
        super(executionTime, scheduler);
        this.recoverer = recoverer;
    }

    @Override
    public Object getObject() {
        return this.recoverer;
    }

    @Override
    public void execute() {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("running recovery");
        }
        Thread recovery = new Thread(this.recoverer);
        recovery.setName("bitronix-recovery-thread");
        recovery.setDaemon(true);
        recovery.setPriority(4);
        recovery.start();
        Date nextExecutionDate = new Date(this.getExecutionTime().getTime() + (long)TransactionManagerServices.getConfiguration().getBackgroundRecoveryIntervalSeconds() * 1000L);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("rescheduling recovery for " + nextExecutionDate);
        }
        this.getTaskScheduler().scheduleRecovery(this.recoverer, nextExecutionDate);
    }

    public String toString() {
        return "a RecoveryTask scheduled for " + this.getExecutionTime();
    }
}

