/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.timer.TaskException;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Task
implements Comparable<Task> {
    private static final AtomicInteger UNIQUE_ID_SOURCE = new AtomicInteger();
    private final Date executionTime;
    private final TaskScheduler taskScheduler;
    private final int uniqueId;

    protected Task(Date executionTime, TaskScheduler scheduler) {
        this.executionTime = executionTime;
        this.taskScheduler = scheduler;
        this.uniqueId = UNIQUE_ID_SOURCE.getAndIncrement();
    }

    protected TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public int hashCode() {
        return Objects.hash(this.getExecutionTime(), this.getUniqueId());
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task task = (Task)o;
        return this.compareTo(task) == 0;
    }

    @Override
    public int compareTo(Task otherTask) {
        int compareResult = this.executionTime.compareTo(otherTask.executionTime);
        if (compareResult == 0) {
            compareResult = Integer.valueOf(this.uniqueId).compareTo(otherTask.getUniqueId());
        }
        return compareResult;
    }

    int getUniqueId() {
        return this.uniqueId;
    }

    public abstract Object getObject();

    public abstract void execute() throws TaskException;
}

