/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.timer.PoolShrinkingTask;
import bitronix.tm.timer.RecoveryTask;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TransactionTimeoutTask;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Service;
import java.util.AbstractSet;
import java.util.Date;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskScheduler
extends Thread
implements Service {
    private static final Logger log = Logger.getLogger(TaskScheduler.class.toString());
    private static final String EXPECTED_EXECUTION_DATE = "expected a non-null execution date";
    private static final String TOTAL_QUEUED = ", total task(s) queued: ";
    private static final String SCHEDULED_STRING = "scheduled ";
    private static final String NO_TASK = "no task found based on object ";
    private final SortedSet<Task> tasks;
    private final Lock tasksLock;
    private final AtomicBoolean active;

    public TaskScheduler() {
        ReentrantLock innerTasksLock;
        AbstractSet sortedTasks;
        block3: {
            this.active = new AtomicBoolean(true);
            this.setDaemon(true);
            this.setName("bitronix-task-scheduler");
            try {
                sortedTasks = new ConcurrentSkipListSet();
                innerTasksLock = null;
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("task scheduler backed by ConcurrentSkipListSet");
                }
            }
            catch (Exception e) {
                sortedTasks = new TreeSet();
                innerTasksLock = new ReentrantLock();
                if (!LogDebugCheck.isDebugEnabled()) break block3;
                log.finer("task scheduler backed by locked TreeSet");
                log.log(Level.FINEST, "exception is", e);
            }
        }
        this.tasks = sortedTasks;
        this.tasksLock = innerTasksLock;
    }

    @Override
    public void shutdown() {
        boolean wasActive = this.setActive(false);
        if (wasActive) {
            try {
                long gracefulShutdownTime = (long)TransactionManagerServices.getConfiguration().getGracefulShutdownInterval() * 1000L;
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("graceful scheduler shutdown interval: " + gracefulShutdownTime + "ms");
                }
                this.join(gracefulShutdownTime);
            }
            catch (InterruptedException ex) {
                log.log(Level.SEVERE, "could not stop the task scheduler within " + TransactionManagerServices.getConfiguration().getGracefulShutdownInterval() + "s", ex);
            }
        }
    }

    boolean setActive(boolean active) {
        return this.active.getAndSet(active);
    }

    public void scheduleTransactionTimeout(BitronixTransaction transaction, Date executionTime) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("scheduling transaction timeout task on " + transaction + " for " + executionTime);
        }
        if (transaction == null) {
            throw new IllegalArgumentException("expected a non-null transaction");
        }
        if (executionTime == null) {
            throw new IllegalArgumentException(EXPECTED_EXECUTION_DATE);
        }
        TransactionTimeoutTask task = new TransactionTimeoutTask(transaction, executionTime, this);
        this.addTask(task);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer(SCHEDULED_STRING + task + TOTAL_QUEUED + this.countTasksQueued());
        }
    }

    void addTask(Task task) {
        this.lock();
        try {
            this.removeTaskByObject(task.getObject());
            this.tasks.add(task);
        }
        finally {
            this.unlock();
        }
    }

    public int countTasksQueued() {
        this.lock();
        try {
            int n = this.tasks.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        if (this.tasksLock != null) {
            this.tasksLock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTaskByObject(Object obj) {
        this.lock();
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("removing task by " + obj);
            }
            for (Task task : this.tasks) {
                if (task.getObject() != obj) continue;
                this.tasks.remove(task);
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("cancelled " + task + ", total task(s) still queued: " + this.tasks.size());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private void unlock() {
        if (this.tasksLock != null) {
            this.tasksLock.unlock();
        }
    }

    public void cancelTransactionTimeout(BitronixTransaction transaction) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("cancelling transaction timeout task on " + transaction);
        }
        if (transaction == null) {
            throw new IllegalArgumentException("expected a non-null transaction");
        }
        if (!this.removeTaskByObject(transaction) && LogDebugCheck.isDebugEnabled()) {
            log.finer(NO_TASK + transaction);
        }
    }

    public void scheduleRecovery(Recoverer recoverer, Date executionTime) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("scheduling recovery task for " + executionTime);
        }
        if (recoverer == null) {
            throw new IllegalArgumentException("expected a non-null recoverer");
        }
        if (executionTime == null) {
            throw new IllegalArgumentException(EXPECTED_EXECUTION_DATE);
        }
        RecoveryTask task = new RecoveryTask(recoverer, executionTime, this);
        this.addTask(task);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer(SCHEDULED_STRING + task + TOTAL_QUEUED + this.countTasksQueued());
        }
    }

    public void cancelRecovery(Recoverer recoverer) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("cancelling recovery task");
        }
        if (!this.removeTaskByObject(recoverer) && LogDebugCheck.isDebugEnabled()) {
            log.finer(NO_TASK + recoverer);
        }
    }

    public void schedulePoolShrinking(XAPool xaPool) {
        Date executionTime = xaPool.getNextShrinkDate();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("scheduling pool shrinking task on " + xaPool + " for " + executionTime);
        }
        if (executionTime == null) {
            throw new IllegalArgumentException(EXPECTED_EXECUTION_DATE);
        }
        PoolShrinkingTask task = new PoolShrinkingTask(xaPool, executionTime, this);
        this.addTask(task);
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer(SCHEDULED_STRING + task + TOTAL_QUEUED + this.tasks.size());
        }
    }

    public void cancelPoolShrinking(XAPool xaPool) {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("cancelling pool shrinking task on " + xaPool);
        }
        if (xaPool == null) {
            throw new IllegalArgumentException("expected a non-null XA pool");
        }
        if (!this.removeTaskByObject(xaPool) && LogDebugCheck.isDebugEnabled()) {
            log.finer(NO_TASK + xaPool);
        }
    }

    @Override
    public void run() {
        while (this.isActive()) {
            try {
                this.executeElapsedTasks();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isActive() {
        return this.active.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeElapsedTasks() {
        this.lock();
        try {
            if (this.tasks.isEmpty()) {
                return;
            }
            HashSet<Task> toRemove = new HashSet<Task>();
            for (Task task : this.getSafeIterableTasks()) {
                if (task.getExecutionTime().compareTo(new Date(MonotonicClock.currentTimeMillis())) > 0) continue;
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("running " + task);
                }
                try {
                    task.execute();
                    if (!LogDebugCheck.isDebugEnabled()) continue;
                    log.finer("successfully ran " + task);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "error running " + task, ex);
                }
                finally {
                    toRemove.add(task);
                    if (!LogDebugCheck.isDebugEnabled()) continue;
                    log.finer("total task(s) still queued: " + this.tasks.size());
                }
            }
            this.tasks.removeAll(toRemove);
        }
        finally {
            this.unlock();
        }
    }

    private SortedSet<Task> getSafeIterableTasks() {
        if (this.tasksLock != null) {
            return new TreeSet<Task>(this.tasks);
        }
        return this.tasks;
    }
}

