/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TaskException;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;
import java.util.logging.Logger;
import javax.transaction.SystemException;

public class TransactionTimeoutTask
extends Task {
    private static final Logger log = Logger.getLogger(TransactionTimeoutTask.class.toString());
    private final BitronixTransaction transaction;

    public TransactionTimeoutTask(BitronixTransaction transaction, Date executionTime, TaskScheduler scheduler) {
        super(executionTime, scheduler);
        this.transaction = transaction;
    }

    @Override
    public Object getObject() {
        return this.transaction;
    }

    @Override
    public void execute() throws TaskException {
        try {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("marking " + this.transaction + " as timed out");
            }
            this.transaction.timeout();
        }
        catch (SystemException ex) {
            throw new TaskException("failed to timeout " + this.transaction, ex);
        }
    }

    public String toString() {
        return "a TransactionTimeoutTask on " + this.transaction + " scheduled for " + this.getExecutionTime();
    }
}

