/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixHeuristicCommitException;
import bitronix.tm.internal.BitronixHeuristicMixedException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.twopc.AbstractPhaseEngine;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.Decoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;

public final class Rollbacker
extends AbstractPhaseEngine {
    private static final Logger log = Logger.getLogger(Rollbacker.class.toString());
    private final List<XAResourceHolderState> interestedResources = Collections.synchronizedList(new ArrayList());
    private final List<XAResourceHolderState> rolledbackResources = Collections.synchronizedList(new ArrayList());

    public Rollbacker(Executor executor) {
        super(executor);
    }

    public void rollback(BitronixTransaction transaction, List<XAResourceHolderState> interestedResources) throws HeuristicMixedException, HeuristicCommitException, SystemException {
        XAResourceManager resourceManager = transaction.getResourceManager();
        transaction.setStatus(9);
        this.interestedResources.clear();
        this.interestedResources.addAll(interestedResources);
        try {
            this.executePhase(resourceManager, true);
        }
        catch (PhaseException ex) {
            this.logFailedResources(ex);
            transaction.setStatus(5);
            this.throwException("transaction failed during rollback of " + transaction, ex, interestedResources.size());
        }
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("rollback executed on resources " + Decoder.collectResourcesNames(this.rolledbackResources));
        }
        HashSet<String> rolledbackAndNotInterestedUniqueNames = new HashSet<String>();
        rolledbackAndNotInterestedUniqueNames.addAll(Rollbacker.collectResourcesUniqueNames(this.rolledbackResources));
        List<XAResourceHolderState> notInterestedResources = Rollbacker.collectNotInterestedResources(resourceManager.getAllResources(), interestedResources);
        rolledbackAndNotInterestedUniqueNames.addAll(Rollbacker.collectResourcesUniqueNames(notInterestedResources));
        if (LogDebugCheck.isDebugEnabled()) {
            ArrayList<XAResourceHolderState> rolledbackAndNotInterestedResources = new ArrayList<XAResourceHolderState>();
            rolledbackAndNotInterestedResources.addAll(this.rolledbackResources);
            rolledbackAndNotInterestedResources.addAll(notInterestedResources);
            log.finer("rollback succeeded on resources " + Decoder.collectResourcesNames(rolledbackAndNotInterestedResources));
        }
        transaction.setStatus(4, rolledbackAndNotInterestedUniqueNames);
    }

    private void throwException(String message, PhaseException phaseException, int totalResourceCount) throws HeuristicMixedException, HeuristicCommitException {
        List<Exception> exceptions = phaseException.getExceptions();
        List<XAResourceHolderState> resources = phaseException.getResourceStates();
        boolean hazard = false;
        ArrayList<XAResourceHolderState> heuristicResources = new ArrayList<XAResourceHolderState>();
        ArrayList<XAResourceHolderState> errorResources = new ArrayList<XAResourceHolderState>();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception ex = exceptions.get(i);
            XAResourceHolderState resourceHolder = resources.get(i);
            if (ex instanceof XAException) {
                XAException xaEx = (XAException)ex;
                switch (xaEx.errorCode) {
                    case 8: {
                        hazard = true;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        heuristicResources.add(resourceHolder);
                        break;
                    }
                    default: {
                        errorResources.add(resourceHolder);
                        break;
                    }
                }
                continue;
            }
            errorResources.add(resourceHolder);
        }
        if (!hazard && heuristicResources.size() == totalResourceCount) {
            throw new BitronixHeuristicCommitException(message + ": all resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally committed", phaseException);
        }
        throw new BitronixHeuristicMixedException(message + ":" + (String)(!errorResources.isEmpty() ? " resource(s) " + Decoder.collectResourcesNames(errorResources) + " threw unexpected exception" : "") + (!errorResources.isEmpty() && !heuristicResources.isEmpty() ? " and" : "") + (String)(!heuristicResources.isEmpty() ? " resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally committed" + (hazard ? " (or hazard happened)" : "") : ""), phaseException);
    }

    @Override
    protected boolean isParticipating(XAResourceHolderState xaResourceHolderState) {
        for (XAResourceHolderState resourceHolderState : this.interestedResources) {
            if (xaResourceHolderState != resourceHolderState) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Job createJob(XAResourceHolderState resourceHolder) {
        return new RollbackJob(resourceHolder);
    }

    private final class RollbackJob
    extends Job {
        public RollbackJob(XAResourceHolderState resourceHolder) {
            super(resourceHolder);
        }

        @Override
        public void execute() {
            try {
                this.rollbackResource(this.getResource());
            }
            catch (RuntimeException ex) {
                this.runtimeException = ex;
            }
            catch (XAException ex) {
                this.xaException = ex;
            }
        }

        private void rollbackResource(XAResourceHolderState resourceHolder) throws XAException {
            try {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("trying to rollback resource " + resourceHolder);
                }
                resourceHolder.getXAResource().rollback(resourceHolder.getXid());
                Rollbacker.this.rolledbackResources.add(resourceHolder);
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("rolled back resource " + resourceHolder);
                }
            }
            catch (XAException ex) {
                this.handleXAException(resourceHolder, ex);
            }
        }

        private void handleXAException(XAResourceHolderState failedResourceHolder, XAException xaException) throws XAException {
            switch (xaException.errorCode) {
                case 6: {
                    this.forgetHeuristicRollback(failedResourceHolder);
                    return;
                }
                case 5: 
                case 7: 
                case 8: {
                    log.severe("heuristic rollback is incompatible with the global state of this transaction - guilty: " + failedResourceHolder);
                    throw xaException;
                }
            }
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(xaException);
            log.log(Level.WARNING, "resource '" + failedResourceHolder.getUniqueName() + "' reported " + Decoder.decodeXAExceptionErrorCode(xaException) + " when asked to rollback transaction branch. Transaction is prepared and will rollback via recovery service when resource availability allows." + (String)(extraErrorDetails == null ? "" : " Extra error=" + extraErrorDetails), xaException);
        }

        private void forgetHeuristicRollback(XAResourceHolderState resourceHolder) {
            try {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("handling heuristic rollback on resource " + resourceHolder.getXAResource());
                }
                resourceHolder.getXAResource().forget(resourceHolder.getXid());
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("forgotten heuristically rolled back resource " + resourceHolder.getXAResource());
                }
            }
            catch (XAException ex) {
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
                log.log(Level.SEVERE, "cannot forget " + resourceHolder.getXid() + " assigned to " + resourceHolder.getXAResource() + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
            }
        }

        public String toString() {
            return "a RollbackJob with " + this.getResource();
        }
    }
}

