/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc.executor;

import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(AsyncExecutor.class.toString());
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    @Override
    public Object submit(Job job) {
        return this.executorService.submit(job);
    }

    @Override
    public void waitFor(Object future, long timeout) {
        Future f = (Future)future;
        try {
            f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new BitronixRuntimeException("job interrupted", ex);
        }
        catch (ExecutionException ex) {
            throw new BitronixRuntimeException("job execution exception", ex);
        }
        catch (TimeoutException ex) {
            log.log(Level.FINEST, "Just Return", ex);
        }
    }

    @Override
    public boolean isDone(Object future) {
        Future f = (Future)future;
        return f.isDone();
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
    }
}

