/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.internal.LogDebugCheck;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderUtils {
    private static final Logger log = Logger.getLogger(ClassLoaderUtils.class.toString());

    private ClassLoaderUtils() {
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        for (Class<?> intf : clazz.getInterfaces()) {
            if (intf.getInterfaces().length > 0) {
                interfaces.addAll(ClassLoaderUtils.getAllInterfaces(intf));
            }
            interfaces.add(intf);
        }
        if (clazz.getSuperclass() != null) {
            interfaces.addAll(ClassLoaderUtils.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        return interfaces;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return new CascadingClassLoader(cl);
        }
        return ClassLoaderUtils.class.getClassLoader();
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        block3: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                try {
                    return new CascadingClassLoader(cl).loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    if (!LogDebugCheck.isDebugEnabled()) break block3;
                    log.log(Level.FINER, "context classloader could not find class '" + className + "', trying Class.forName() instead", ex);
                }
            }
        }
        return Class.forName(className);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl.getResourceAsStream(resourceName);
        }
        return ClassLoaderUtils.class.getClassLoader().getResourceAsStream(resourceName);
    }

    private static class CascadingClassLoader
    extends ClassLoader {
        private final ClassLoader contextLoader;

        CascadingClassLoader(ClassLoader contextLoader) {
            this.contextLoader = contextLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.contextLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                log.log(Level.FINEST, "Class not found?", cnfe);
                return CascadingClassLoader.class.getClassLoader().loadClass(name);
            }
        }
    }
}

