/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

public class Encoder {
    private Encoder() {
    }

    public static byte[] longToBytes(long aLong) {
        byte[] array = new byte[8];
        array[7] = (byte)(aLong & 0xFFL);
        array[6] = (byte)(aLong >> 8 & 0xFFL);
        array[5] = (byte)(aLong >> 16 & 0xFFL);
        array[4] = (byte)(aLong >> 24 & 0xFFL);
        array[3] = (byte)(aLong >> 32 & 0xFFL);
        array[2] = (byte)(aLong >> 40 & 0xFFL);
        array[1] = (byte)(aLong >> 48 & 0xFFL);
        array[0] = (byte)(aLong >> 56 & 0xFFL);
        return array;
    }

    public static byte[] intToBytes(int anInt) {
        byte[] array = new byte[4];
        array[3] = (byte)(anInt & 0xFF);
        array[2] = (byte)(anInt >> 8 & 0xFF);
        array[1] = (byte)(anInt >> 16 & 0xFF);
        array[0] = (byte)(anInt >> 24 & 0xFF);
        return array;
    }

    public static byte[] shortToBytes(short aShort) {
        byte[] array = new byte[2];
        array[1] = (byte)(aShort & 0xFF);
        array[0] = (byte)(aShort >> 8 & 0xFF);
        return array;
    }

    public static long bytesToLong(byte[] bytes, int pos) {
        if (bytes.length + pos < 8) {
            throw new IllegalArgumentException("a long can only be decoded from 8 bytes of an array (got a " + bytes.length + " byte(s) array, must start at position " + pos + ")");
        }
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result ^= (long)bytes[i + pos] & 0xFFL;
        }
        return result;
    }

    public static int bytesToInt(byte[] bytes, int pos) {
        if (bytes.length + pos < 4) {
            throw new IllegalArgumentException("an integer can only be decoded from 4 bytes of an array (got a " + bytes.length + " byte(s) array, must start at position " + pos + ")");
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result ^= bytes[i + pos] & 0xFF;
        }
        return result;
    }
}

