/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

class EncryptService {
    private static final String cipher = "DES";
    private final SecretKey key;
    private Cipher ecipher;
    private Cipher dcipher;

    public EncryptService(String keyPass, boolean encrypt) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        DESKeySpec desKeySpec = new DESKeySpec(keyPass.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(cipher);
        this.key = keyFactory.generateSecret(desKeySpec);
        if (encrypt) {
            this.ecipher = Cipher.getInstance(cipher);
        } else {
            this.dcipher = Cipher.getInstance(cipher);
        }
        if (encrypt) {
            this.ecipher.init(1, this.key);
        } else {
            this.dcipher.init(2, this.key);
        }
    }

    public String encrypt(String message) throws BadPaddingException, IllegalBlockSizeException {
        byte[] utf8 = message.getBytes(StandardCharsets.UTF_8);
        byte[] enc = this.ecipher.doFinal(utf8);
        return Base64.getEncoder().encodeToString(enc);
    }

    public String decrypt(String message) throws BadPaddingException, IllegalBlockSizeException {
        byte[] dec = Base64.getDecoder().decode(message.getBytes());
        byte[] utf8 = this.dcipher.doFinal(dec);
        return new String(utf8, StandardCharsets.UTF_8);
    }
}

