/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.utils.PropertyException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class PropertyUtils {
    private static final String DASH_QUOTE_SPACE = "' - '";
    private static final String IS_NOT_ACCESSIBLE = "' is not accessible";
    private static final String PROPERTY_STRING = "property '";
    private static final String ACCESS_EXCEPTION = "' access threw an exception";
    private static final String IN_CLASS_STRING = "' in class '";

    private PropertyUtils() {
    }

    public static void setProperties(Object target, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            PropertyUtils.setProperty(target, name, value);
        }
    }

    public static void setProperty(Object target, String propertyName, Object propertyValue) {
        String[] propertyNames = propertyName.split("\\.");
        StringBuilder visitedPropertyName = new StringBuilder();
        Object currentTarget = target;
        Object parentTarget = target;
        String parentName = null;
        for (int i = 0; i < propertyNames.length - 1; ++i) {
            String name = propertyNames[i];
            Object result = PropertyUtils.callGetter(currentTarget, name);
            if (result == null) {
                Class<?> propertyType = PropertyUtils.getPropertyType(target, name);
                try {
                    result = propertyType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new PropertyException("cannot set property '" + propertyName + DASH_QUOTE_SPACE + name + "' is null and cannot be auto-filled", ex);
                }
                PropertyUtils.callSetter(currentTarget, name, result);
            }
            parentTarget = currentTarget;
            currentTarget = result;
            visitedPropertyName.append(name);
            visitedPropertyName.append('.');
            if (!(currentTarget instanceof Map)) continue;
            parentName = name;
            break;
        }
        String lastPropertyName = propertyName.substring(visitedPropertyName.length());
        if (currentTarget instanceof Map) {
            Map p = (Map)currentTarget;
            p.put(lastPropertyName, propertyValue.toString());
            if (parentName != null) {
                PropertyUtils.callSetter(parentTarget, parentName, p);
            }
        } else {
            PropertyUtils.setDirectProperty(currentTarget, lastPropertyName, propertyValue);
        }
    }

    private static Object callGetter(Object target, String propertyName) {
        Method getter = PropertyUtils.getGetter(target, propertyName);
        try {
            return getter.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException(PROPERTY_STRING + propertyName + IS_NOT_ACCESSIBLE, ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException(PROPERTY_STRING + propertyName + ACCESS_EXCEPTION, ex);
        }
    }

    private static Class<?> getPropertyType(Object target, String propertyName) {
        Method[] methods;
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String getterIsName = "is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equals(getterName) && !method.getName().equals(getterIsName) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            return method.getReturnType();
        }
        throw new PropertyException("no property '" + propertyName + IN_CLASS_STRING + target.getClass().getName() + "'");
    }

    private static void callSetter(Object target, String propertyName, Object parameter) {
        Method setter = PropertyUtils.getSetter(target, propertyName);
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException(PROPERTY_STRING + propertyName + IS_NOT_ACCESSIBLE, ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException(PROPERTY_STRING + propertyName + ACCESS_EXCEPTION, ex);
        }
    }

    private static void setDirectProperty(Object target, String propertyName, Object propertyValue) {
        Method setter = PropertyUtils.getSetter(target, propertyName);
        Class<?> parameterType = setter.getParameterTypes()[0];
        try {
            if (propertyValue != null) {
                Object transformedPropertyValue = PropertyUtils.transform(propertyValue, parameterType);
                setter.invoke(target, transformedPropertyValue);
            } else {
                setter.invoke(target, new Object[0]);
            }
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException(PROPERTY_STRING + propertyName + IS_NOT_ACCESSIBLE, ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException(PROPERTY_STRING + propertyName + ACCESS_EXCEPTION, ex);
        }
    }

    private static Method getGetter(Object target, String propertyName) {
        Method[] methods;
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String getterIsName = "is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equals(getterName) && !method.getName().equals(getterIsName) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        throw new PropertyException("no readable property '" + propertyName + IN_CLASS_STRING + target.getClass().getName() + "'");
    }

    private static Method getSetter(Object target, String propertyName) {
        Method[] methods;
        if (propertyName == null || "".equals(propertyName)) {
            throw new PropertyException("encountered invalid null or empty property name");
        }
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equals(setterName) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        throw new PropertyException("no writeable property '" + propertyName + IN_CLASS_STRING + target.getClass().getName() + "'");
    }

    private static Object transform(Object value, Class<?> destinationClass) {
        if (value.getClass() == destinationClass) {
            return value;
        }
        if (value.getClass() == Boolean.TYPE || value.getClass() == Boolean.class || value.getClass() == Byte.TYPE || value.getClass() == Byte.class || value.getClass() == Short.TYPE || value.getClass() == Short.class || value.getClass() == Integer.TYPE || value.getClass() == Integer.class || value.getClass() == Long.TYPE || value.getClass() == Long.class || value.getClass() == Float.TYPE || value.getClass() == Float.class || value.getClass() == Double.TYPE || value.getClass() == Double.class) {
            return value;
        }
        if ((destinationClass == Boolean.TYPE || destinationClass == Boolean.class) && value.getClass() == String.class) {
            return Boolean.valueOf((String)value);
        }
        if ((destinationClass == Byte.TYPE || destinationClass == Byte.class) && value.getClass() == String.class) {
            return Byte.valueOf((String)value);
        }
        if ((destinationClass == Short.TYPE || destinationClass == Short.class) && value.getClass() == String.class) {
            return Short.valueOf((String)value);
        }
        if ((destinationClass == Integer.TYPE || destinationClass == Integer.class) && value.getClass() == String.class) {
            return Integer.valueOf((String)value);
        }
        if ((destinationClass == Long.TYPE || destinationClass == Long.class) && value.getClass() == String.class) {
            return Long.valueOf((String)value);
        }
        if ((destinationClass == Float.TYPE || destinationClass == Float.class) && value.getClass() == String.class) {
            return Float.valueOf((String)value);
        }
        if ((destinationClass == Double.TYPE || destinationClass == Double.class) && value.getClass() == String.class) {
            return Double.valueOf((String)value);
        }
        throw new PropertyException("cannot convert values of type '" + value.getClass().getName() + "' into type '" + destinationClass + "'");
    }

    public static String propertiesToString(Object obj) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, Object> properties = new TreeMap<String, Object>(PropertyUtils.getProperties(obj));
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String property = (String)it.next();
            Object val = PropertyUtils.getProperty(obj, property);
            sb.append(property);
            sb.append("=");
            sb.append(val);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static Map<String, Object> getProperties(Object target) {
        Method[] methods;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            String propertyName;
            String name = method.getName();
            if (method.getModifiers() != 1 || method.getParameterTypes().length != 0 || !name.startsWith("get") && !name.startsWith("is") || !PropertyUtils.containsSetterForGetter(clazz, method)) continue;
            if (name.startsWith("get")) {
                propertyName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            } else if (name.startsWith("is")) {
                propertyName = Character.toLowerCase(name.charAt(2)) + name.substring(3);
            } else {
                throw new PropertyException("method '" + name + "' is not a getter, thereof no setter can be found");
            }
            try {
                Object propertyValue = method.invoke(target, new Object[0]);
                if (propertyValue instanceof Map) {
                    Map<String, Object> propertiesContent = PropertyUtils.getNestedProperties(propertyName, (Map)propertyValue);
                    properties.putAll(propertiesContent);
                    continue;
                }
                properties.put(propertyName, propertyValue);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new PropertyException("cannot set property '" + propertyName + DASH_QUOTE_SPACE + name + "' is null and cannot be auto-filled", ex);
            }
        }
        return properties;
    }

    public static Object getProperty(Object target, String propertyName) {
        String[] propertyNames = propertyName.split("\\.");
        Object currentTarget = target;
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            Object result = PropertyUtils.callGetter(currentTarget, name);
            if (result == null && i < propertyNames.length - 1) {
                throw new PropertyException("cannot get property '" + propertyName + DASH_QUOTE_SPACE + name + "' is null");
            }
            currentTarget = result;
        }
        return currentTarget;
    }

    private static boolean containsSetterForGetter(Class<?> clazz, Method method) {
        Method[] methods;
        String setterName;
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            setterName = "set" + methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            setterName = "set" + methodName.substring(2);
        } else {
            throw new PropertyException("method '" + methodName + "' is not a getter, thereof no setter can be found");
        }
        for (Method m : methods = clazz.getMethods()) {
            if (!m.getName().equals(setterName)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Object> getNestedProperties(String prefix, Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = (String)entry.getValue();
            result.put(prefix + "." + name, value);
        }
        return result;
    }
}

