/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Scheduler<T>
implements Iterable<T> {
    public static final Integer DEFAULT_POSITION = 0;
    public static final Integer ALWAYS_FIRST_POSITION = Integer.MIN_VALUE;
    public static final Integer ALWAYS_LAST_POSITION = Integer.MAX_VALUE;
    private final List<Integer> keys = new ArrayList<Integer>();
    private final Map<Integer, List<T>> objects = new TreeMap<Integer, List<T>>();
    private int size = 0;

    public synchronized void add(T obj, Integer position) {
        List<T> list = this.objects.get(position);
        if (list == null) {
            if (!this.keys.contains(position)) {
                this.keys.add(position);
                Collections.sort(this.keys);
            }
            list = new ArrayList<T>();
            this.objects.put(position, list);
        }
        list.add(obj);
        ++this.size;
    }

    public synchronized void remove(T obj) {
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            T o = it.next();
            if (o != obj) continue;
            it.remove();
            return;
        }
        throw new NoSuchElementException("no such element: " + obj);
    }

    @Override
    public Iterator<T> iterator() {
        return new SchedulerNaturalOrderIterator();
    }

    public synchronized SortedSet<Integer> getReverseOrderPositions() {
        TreeSet<Integer> result = new TreeSet<Integer>(Collections.reverseOrder());
        result.addAll(this.getNaturalOrderPositions());
        return result;
    }

    public synchronized SortedSet<Integer> getNaturalOrderPositions() {
        return new TreeSet<Integer>(this.objects.keySet());
    }

    public synchronized List<T> getByReverseOrderForPosition(Integer position) {
        ArrayList<T> result = new ArrayList<T>(this.getByNaturalOrderForPosition(position));
        Collections.reverse(result);
        return result;
    }

    public synchronized List<T> getByNaturalOrderForPosition(Integer position) {
        return this.objects.get(position);
    }

    public Iterator<T> reverseIterator() {
        return new SchedulerReverseOrderIterator();
    }

    public String toString() {
        return "a Scheduler with " + this.size() + " object(s) in " + this.getNaturalOrderPositions().size() + " position(s)";
    }

    public synchronized int size() {
        return this.size;
    }

    private final class SchedulerReverseOrderIterator
    implements Iterator<T> {
        private int nextKeyIndex;
        private List<T> objectsOfCurrentKey;
        private int objectsOfCurrentKeyIndex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SchedulerReverseOrderIterator() {
            Scheduler scheduler2 = Scheduler.this;
            synchronized (scheduler2) {
                this.nextKeyIndex = Scheduler.this.keys.size() - 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null) {
                    throw new NoSuchElementException("iterator not yet placed on an element");
                }
                --this.objectsOfCurrentKeyIndex;
                this.objectsOfCurrentKey.remove(this.objectsOfCurrentKeyIndex);
                if (this.objectsOfCurrentKey.isEmpty()) {
                    Integer key = Scheduler.this.keys.get(this.nextKeyIndex + 1);
                    Scheduler.this.keys.remove(this.nextKeyIndex + 1);
                    Scheduler.this.objects.remove(key);
                    this.objectsOfCurrentKey = null;
                }
                --Scheduler.this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null || this.objectsOfCurrentKeyIndex >= this.objectsOfCurrentKey.size()) {
                    if (this.nextKeyIndex >= 0) {
                        Integer currentKey = Scheduler.this.keys.get(this.nextKeyIndex--);
                        this.objectsOfCurrentKey = Scheduler.this.objects.get(currentKey);
                        this.objectsOfCurrentKeyIndex = 0;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("iterator bounds reached");
                }
                return this.objectsOfCurrentKey.get(this.objectsOfCurrentKeyIndex++);
            }
        }
    }

    private final class SchedulerNaturalOrderIterator
    implements Iterator<T> {
        private int nextKeyIndex = 0;
        private List<T> objectsOfCurrentKey;
        private int objectsOfCurrentKeyIndex;

        private SchedulerNaturalOrderIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null) {
                    throw new NoSuchElementException("iterator not yet placed on an element");
                }
                --this.objectsOfCurrentKeyIndex;
                this.objectsOfCurrentKey.remove(this.objectsOfCurrentKeyIndex);
                if (this.objectsOfCurrentKey.isEmpty()) {
                    --this.nextKeyIndex;
                    Integer key = Scheduler.this.keys.get(this.nextKeyIndex);
                    Scheduler.this.keys.remove(this.nextKeyIndex);
                    Scheduler.this.objects.remove(key);
                    this.objectsOfCurrentKey = null;
                }
                --Scheduler.this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null || this.objectsOfCurrentKeyIndex >= this.objectsOfCurrentKey.size()) {
                    if (this.nextKeyIndex < Scheduler.this.keys.size()) {
                        Integer currentKey = Scheduler.this.keys.get(this.nextKeyIndex++);
                        this.objectsOfCurrentKey = Scheduler.this.objects.get(currentKey);
                        this.objectsOfCurrentKeyIndex = 0;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("iterator bounds reached");
                }
                return this.objectsOfCurrentKey.get(this.objectsOfCurrentKeyIndex++);
            }
        }
    }
}

