/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.shade.findbugs.annotations.SuppressFBWarnings;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraalImageCode
extends Enum<GraalImageCode> {
    public static final /* enum */ GraalImageCode AGENT;
    public static final /* enum */ GraalImageCode BUILD;
    public static final /* enum */ GraalImageCode RUNTIME;
    public static final /* enum */ GraalImageCode UNKNOWN;
    public static final /* enum */ GraalImageCode NONE;
    @MaybeNull
    private static GraalImageCode current;
    private final boolean defined;
    private final boolean nativeImageExecution;
    private static final /* synthetic */ GraalImageCode[] $VALUES;
    private static final boolean ACCESS_CONTROLLER;

    public static GraalImageCode[] values() {
        return (GraalImageCode[])$VALUES.clone();
    }

    public static GraalImageCode valueOf(String name) {
        return Enum.valueOf(GraalImageCode.class, name);
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="This behaviour is intended to avoid early binding in native images.")
    public static GraalImageCode getCurrent() {
        GraalImageCode current = GraalImageCode.current;
        if (current == null) {
            String value = GraalImageCode.doPrivileged(new GetSystemPropertyAction("org.graalvm.nativeimage.imagecode"));
            current = value == null ? NONE : (value.equalsIgnoreCase("agent") ? AGENT : (value.equalsIgnoreCase("runtime") ? RUNTIME : (value.equalsIgnoreCase("buildtime") ? BUILD : UNKNOWN)));
            GraalImageCode.current = current;
        }
        return current;
    }

    @MaybeNull
    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    private GraalImageCode(boolean defined, boolean nativeImageExecution) {
        this.defined = defined;
        this.nativeImageExecution = nativeImageExecution;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isNativeImageExecution() {
        return this.nativeImageExecution;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        AGENT = new GraalImageCode(true, false);
        BUILD = new GraalImageCode(true, false);
        RUNTIME = new GraalImageCode(true, true);
        UNKNOWN = new GraalImageCode(false, false);
        NONE = new GraalImageCode(false, false);
        $VALUES = new GraalImageCode[]{AGENT, BUILD, RUNTIME, UNKNOWN, NONE};
    }
}

