/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Transform;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMTransform
extends Transform {
    public List preprocess(List list) throws XPathException {
        try {
            ArrayList<DocumentWrapper> arrayList = new ArrayList<DocumentWrapper>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                StreamSource streamSource = (StreamSource)list.get(i);
                InputSource inputSource = new InputSource(streamSource.getSystemId());
                System.setProperty("javax.xml.parser.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                DocumentWrapper documentWrapper = new DocumentWrapper((Node)document, streamSource.getSystemId(), this.getConfiguration());
                arrayList.add(documentWrapper);
            }
            return arrayList;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DynamicError(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public static void main(String[] stringArray) {
        new DOMTransform().doTransform(stringArray, "DOMTransform");
    }
}

