/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist.jpa;

import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.finder.Finder;
import com.google.inject.persist.finder.FirstResult;
import com.google.inject.persist.finder.MaxResults;
import jakarta.inject.Named;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

@Singleton
class JpaFinderProxy
implements MethodInterceptor {
    private final Map<Method, FinderDescriptor> finderCache = new MapMaker().weakKeys().makeMap();
    private final Provider<EntityManager> emProvider;

    @Inject
    public JpaFinderProxy(Provider<EntityManager> emProvider) {
        this.emProvider = emProvider;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        EntityManager em = (EntityManager)this.emProvider.get();
        FinderDescriptor finderDescriptor = this.getFinderDescriptor(methodInvocation);
        Object[] result = null;
        Query jpaQuery = finderDescriptor.createQuery(em);
        if (finderDescriptor.isBindAsRawParameters) {
            this.bindQueryRawParameters(jpaQuery, finderDescriptor, methodInvocation.getArguments());
        } else {
            this.bindQueryNamedParameters(jpaQuery, finderDescriptor, methodInvocation.getArguments());
        }
        if (ReturnType.PLAIN.equals((Object)finderDescriptor.returnType)) {
            result = jpaQuery.getSingleResult();
        } else if (ReturnType.COLLECTION.equals((Object)finderDescriptor.returnType)) {
            result = this.getAsCollection(finderDescriptor, jpaQuery.getResultList());
        } else if (ReturnType.ARRAY.equals((Object)finderDescriptor.returnType)) {
            result = jpaQuery.getResultList().toArray();
        }
        return result;
    }

    private Object getAsCollection(FinderDescriptor finderDescriptor, List results) {
        Collection collection;
        try {
            collection = (Collection)finderDescriptor.returnCollectionTypeConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Specified collection class of Finder's returnAs could not be instantated: " + finderDescriptor.returnCollectionType, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Specified collection class of Finder's returnAs could not be instantated (do not have access privileges): " + finderDescriptor.returnCollectionType, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Specified collection class of Finder's returnAs could not be instantated (it threw an exception): " + finderDescriptor.returnCollectionType, e);
        }
        collection.addAll(results);
        return collection;
    }

    private void bindQueryNamedParameters(Query jpaQuery, FinderDescriptor descriptor, Object[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            com.google.inject.name.Named named;
            Object argument = arguments[i];
            Object annotation = descriptor.parameterAnnotations[i];
            if (null == annotation) continue;
            if (annotation instanceof com.google.inject.name.Named) {
                named = (com.google.inject.name.Named)annotation;
                jpaQuery.setParameter(named.value(), argument);
                continue;
            }
            if (annotation instanceof Named) {
                named = (Named)annotation;
                jpaQuery.setParameter(named.value(), argument);
                continue;
            }
            if (annotation instanceof FirstResult) {
                jpaQuery.setFirstResult(((Integer)argument).intValue());
                continue;
            }
            if (!(annotation instanceof MaxResults)) continue;
            jpaQuery.setMaxResults(((Integer)argument).intValue());
        }
    }

    private void bindQueryRawParameters(Query jpaQuery, FinderDescriptor descriptor, Object[] arguments) {
        int index = 1;
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            Object annotation = descriptor.parameterAnnotations[i];
            if (null == annotation) {
                jpaQuery.setParameter(index, argument);
                ++index;
                continue;
            }
            if (annotation instanceof FirstResult) {
                jpaQuery.setFirstResult(((Integer)argument).intValue());
                continue;
            }
            if (!(annotation instanceof MaxResults)) continue;
            jpaQuery.setMaxResults(((Integer)argument).intValue());
        }
    }

    private FinderDescriptor getFinderDescriptor(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        FinderDescriptor finderDescriptor = this.finderCache.get(method);
        if (null != finderDescriptor) {
            return finderDescriptor;
        }
        finderDescriptor = new FinderDescriptor();
        finderDescriptor.returnClass = invocation.getMethod().getReturnType();
        finderDescriptor.returnType = this.determineReturnType(finderDescriptor.returnClass);
        Finder finder = invocation.getMethod().getAnnotation(Finder.class);
        String query = finder.query();
        if (!"".equals(query.trim())) {
            finderDescriptor.setQuery(query);
        } else {
            finderDescriptor.setNamedQuery(finder.namedQuery());
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] discoveredAnnotations = new Object[parameterAnnotations.length];
        block2: for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (com.google.inject.name.Named.class.equals(annotationType) || Named.class.equals(annotationType)) {
                    discoveredAnnotations[i] = annotation;
                    finderDescriptor.isBindAsRawParameters = false;
                    continue block2;
                }
                if (FirstResult.class.equals(annotationType)) {
                    discoveredAnnotations[i] = annotation;
                    continue block2;
                }
                if (!MaxResults.class.equals(annotationType)) continue;
                discoveredAnnotations[i] = annotation;
                continue block2;
            }
        }
        finderDescriptor.parameterAnnotations = discoveredAnnotations;
        if (ReturnType.COLLECTION.equals((Object)finderDescriptor.returnType) && finderDescriptor.returnClass != Collection.class) {
            finderDescriptor.returnCollectionType = finder.returnAs();
            try {
                finderDescriptor.returnCollectionTypeConstructor = finderDescriptor.returnCollectionType.getConstructor(new Class[0]);
                finderDescriptor.returnCollectionTypeConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Finder's collection return type specified has no default constructor! returnAs: " + finderDescriptor.returnCollectionType, e);
            }
        }
        this.cacheFinderDescriptor(method, finderDescriptor);
        return finderDescriptor;
    }

    private void cacheFinderDescriptor(Method method, FinderDescriptor finderDescriptor) {
        this.finderCache.put(method, finderDescriptor);
    }

    private ReturnType determineReturnType(Class<?> returnClass) {
        if (Collection.class.isAssignableFrom(returnClass)) {
            return ReturnType.COLLECTION;
        }
        if (returnClass.isArray()) {
            return ReturnType.ARRAY;
        }
        return ReturnType.PLAIN;
    }

    private static enum ReturnType {
        PLAIN,
        COLLECTION,
        ARRAY;

    }

    private static class FinderDescriptor {
        private volatile boolean isKeyedQuery = false;
        volatile boolean isBindAsRawParameters = true;
        volatile ReturnType returnType;
        volatile Class<?> returnClass;
        volatile Class<? extends Collection> returnCollectionType;
        volatile Constructor<?> returnCollectionTypeConstructor;
        volatile Object[] parameterAnnotations;
        private String query;
        private String name;

        private FinderDescriptor() {
        }

        void setQuery(String query) {
            this.query = query;
        }

        void setNamedQuery(String name) {
            this.name = name;
            this.isKeyedQuery = true;
        }

        public boolean isKeyedQuery() {
            return this.isKeyedQuery;
        }

        Query createQuery(EntityManager em) {
            return this.isKeyedQuery ? em.createNamedQuery(this.name) : em.createQuery(this.query);
        }
    }
}

