/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import com.google.common.base.Stopwatch;
import jakarta.annotation.concurrent.NotThreadSafe;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

@NotThreadSafe
public final class ContinuousStopwatch {
    private final Logger logger = Logger.getLogger(ContinuousStopwatch.class.getName());
    private final Stopwatch stopwatch;

    public ContinuousStopwatch(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
        this.reset();
    }

    public long reset() {
        long elapsedTimeMs = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.stopwatch.reset();
        this.stopwatch.start();
        return elapsedTimeMs;
    }

    public void resetAndLog(String label) {
        long l = this.reset();
        this.logger.fine(new StringBuilder(24 + String.valueOf(label).length()).append(label).append(": ").append(l).append("ms").toString());
    }
}

