/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.ProcessingEnvironment;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LoggingClass;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.generator.model.ImplementationClassModel;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;

final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private static final String FQCN_FIELD_NAME = "FQCN";
    private final Map<String, JVarDeclaration> logOnceVars = new HashMap<String, JVarDeclaration>();

    public MessageLoggerImplementor(ProcessingEnvironment processingEnv, MessageInterface messageInterface) {
        super(processingEnv, messageInterface);
    }

    @Override
    protected JClassDef generateModel() throws IllegalStateException {
        JAssignableExpr logger;
        JClassDef classDef = super.generateModel();
        if (this.messageInterface().loggingFQCN() == null) {
            classDef.field(74, String.class, FQCN_FIELD_NAME, (JExpr)JTypes.$t(classDef)._class().call("getName"));
        } else {
            classDef.field(74, String.class, FQCN_FIELD_NAME, (JExpr)JTypes.$t(this.messageInterface().loggingFQCN())._class().call("getName"));
        }
        JMethodDef constructor = classDef.constructor(32);
        JType loggerType = JTypes.$t(Logger.class);
        this.sourceFile._import(loggerType);
        JParamDeclaration constructorParam = constructor.param(2, loggerType, LOG_FIELD_NAME);
        JBlock constructorBody = constructor.body();
        if (this.messageInterface().extendsLoggerInterface()) {
            this.sourceFile._import(DelegatingBasicLogger.class);
            classDef._extends(DelegatingBasicLogger.class);
            constructorBody.callSuper().arg(JExprs.$v(constructorParam));
            logger = JExprs.$v("super").field(LOG_FIELD_NAME);
        } else {
            JVarDeclaration logVar = classDef.field(18, loggerType, LOG_FIELD_NAME);
            constructorBody.assign(JExpr.THIS.field(logVar.name()), JExprs.$v(constructorParam));
            logger = JExprs.$v(logVar);
        }
        JCall localeGetter = this.createLocaleGetter(null, false);
        LinkedHashSet<MessageMethod> messageMethods = new LinkedHashSet<MessageMethod>();
        messageMethods.addAll(this.messageInterface().methods());
        for (MessageInterface messageInterface : this.messageInterface().extendedInterfaces()) {
            if (!messageInterface.isAnnotatedWith(MessageBundle.class) && !messageInterface.isAnnotatedWith(MessageLogger.class)) continue;
            messageMethods.addAll(messageInterface.methods());
        }
        for (MessageMethod messageMethod : messageMethods) {
            if (messageMethod.isLoggerMethod()) {
                this.createLoggerMethod(messageMethod, classDef, logger);
                continue;
            }
            this.createBundleMethod(classDef, localeGetter, messageMethod);
        }
        return classDef;
    }

    private void createLoggerMethod(MessageMethod messageMethod, JClassDef classDef, JAssignableExpr logger) {
        JBlock body;
        String msgMethodName = messageMethod.messageMethodName();
        JMethodDef method = classDef.method(34, messageMethod.returnType().name(), messageMethod.name());
        method.annotate(Override.class);
        this.addMessageMethod(messageMethod);
        this.addThrownTypes(messageMethod, method);
        Map<Parameter, JParamDeclaration> params = this.createParameters(messageMethod, method);
        ArrayList<String> parameterNames = new ArrayList<String>(params.size());
        for (Parameter param : params.keySet()) {
            parameterNames.add(param.name());
        }
        if (messageMethod.isAnnotatedWith(Once.class) && messageMethod.isLoggerMethod()) {
            JVarDeclaration var;
            JType atomicBoolean = JTypes.$t(AtomicBoolean.class);
            this.sourceFile._import(atomicBoolean);
            String varName = messageMethod.name() + "_$Once";
            if (this.logOnceVars.containsKey(varName)) {
                var = this.logOnceVars.get(varName);
            } else {
                var = classDef.field(74, atomicBoolean, varName, (JExpr)atomicBoolean._new().arg(JExpr.FALSE));
                this.logOnceVars.put(varName, var);
            }
            body = method.body()._if(logger.call("isEnabled").arg(JExprs.$v(messageMethod.logLevel())).and(JExprs.$v(var).call("compareAndSet").arg(JExpr.FALSE).arg(JExpr.TRUE))).block(JBlock.Braces.REQUIRED);
        } else {
            body = !messageMethod.parametersAnnotatedWith(Transform.class).isEmpty() ? method.body()._if(logger.call("isEnabled").arg(JExprs.$v(messageMethod.logLevel()))).block(JBlock.Braces.REQUIRED) : method.body();
        }
        JCall logCaller = logger.call(messageMethod.loggerMethod());
        Set<Parameter> fqcnParameters = messageMethod.parametersAnnotatedWith(LoggingClass.class);
        if (fqcnParameters.isEmpty()) {
            logCaller.arg(JExprs.$v(FQCN_FIELD_NAME));
        } else {
            logCaller.arg(JExprs.$v(params.get(fqcnParameters.iterator().next())).call("getName"));
        }
        String levelName = messageMethod.logLevel();
        this.sourceFile.importStatic(Logger.Level.class, levelName);
        logCaller.arg(JExprs.$v(levelName));
        MessageMethod.Message message = messageMethod.message();
        if (message.format() == Message.Format.NO_FORMAT) {
            logCaller.arg(JExprs.call(msgMethodName));
            logCaller.arg(JExpr.NULL);
            if (messageMethod.hasCause()) {
                logCaller.arg(JExprs.$v(messageMethod.cause().name()));
            } else {
                logCaller.arg(JExpr.NULL);
            }
        } else {
            if (messageMethod.hasCause()) {
                logCaller.arg(JExprs.$v(messageMethod.cause().name()));
            } else {
                logCaller.arg(JExpr.NULL);
            }
            logCaller.arg(JExprs.call(msgMethodName));
            ArrayList<JExpr> args = new ArrayList<JExpr>();
            for (Map.Entry<Parameter, JParamDeclaration> entry : params.entrySet()) {
                Parameter param = entry.getKey();
                String formatterClass = param.formatterClass();
                JParamDeclaration var = entry.getValue();
                boolean added = false;
                if (!param.isFormatParameter()) continue;
                if (param.isAnnotatedWith(Transform.class)) {
                    JAssignableExpr transformVar = this.createTransformVar(parameterNames, body, param, JExprs.$v(var));
                    if (formatterClass == null) {
                        args.add(transformVar);
                    } else {
                        args.add(JTypes.$t(formatterClass)._new().arg(transformVar));
                    }
                    added = true;
                }
                if (param.isAnnotatedWith(Pos.class)) {
                    Pos pos = param.getAnnotation(Pos.class);
                    int[] positions = pos.value();
                    Transform[] transform = pos.transform();
                    for (int i = 0; i < positions.length; ++i) {
                        int index = positions[i] - 1;
                        if (transform != null && transform.length > 0) {
                            JAssignableExpr tVar = this.createTransformVar(parameterNames, body, param, transform[i], JExprs.$v(var));
                            if (index < args.size()) {
                                args.add(index, tVar);
                                continue;
                            }
                            args.add(tVar);
                            continue;
                        }
                        if (index < args.size()) {
                            args.add(index, JExprs.$v(var));
                            continue;
                        }
                        args.add(JExprs.$v(var));
                    }
                    added = true;
                }
                if (added) continue;
                if (formatterClass == null) {
                    if (param.isArray() || param.isVarArgs()) {
                        args.add(JTypes.$t(Arrays.class).call("toString").arg(JExprs.$v(var)));
                        continue;
                    }
                    args.add(JExprs.$v(var));
                    continue;
                }
                args.add(JTypes.$t(formatterClass)._new().arg(JExprs.$v(var)));
            }
            for (JExpr arg : args) {
                logCaller.arg(arg);
            }
        }
        body.add(logCaller);
    }

    private Map<Parameter, JParamDeclaration> createParameters(MessageMethod messageMethod, JMethodDef method) {
        LinkedHashMap<Parameter, JParamDeclaration> result = new LinkedHashMap<Parameter, JParamDeclaration>();
        for (Parameter param : messageMethod.parameters()) {
            JParamDeclaration var = this.addMethodParameter(method, param);
            result.put(param, var);
        }
        return result;
    }
}

