/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.responsive;

import com.guigarage.responsive.DeviceType;
import com.guigarage.responsive.Util;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.stage.Window;

public class ResponsiveHandler {
    private static String PROP_MANAGED_STATE = "responsivefx-preset-managed-state";
    private static InvalidationListener MANAGED_LISTENER = e -> {
        BooleanProperty managed = (BooleanProperty)e;
        Node node = (Node)managed.getBean();
        node.getProperties().put((Object)PROP_MANAGED_STATE, (Object)node.isManaged());
    };
    public static final ObjectProperty<DeviceType> deviceTypeProperty = new ObjectPropertyBase<DeviceType>(DeviceType.NONE){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "deviceType";
        }
    };

    public static void addResponsiveToWindow(Window window) {
        SimpleStringProperty stylesheet = new SimpleStringProperty(ResponsiveHandler.getCurrentResponsiveStylesheet(window));
        Util.bindStyleSheetToWindow(window, (StringProperty)stylesheet);
        ResponsiveHandler.updatePseudoClassesForAllChildren(window);
        ResponsiveHandler.updateManagedPropertyForAllChildren(window);
        Util.registerRecursiveChildObserver(window, n -> ResponsiveHandler.removeAllPseudoClasses(n), n -> ResponsiveHandler.updatePseudoClasses(n, ResponsiveHandler.getTypeForWindow(window)));
        window.widthProperty().addListener(arg_0 -> ResponsiveHandler.lambda$addResponsiveToWindow$7((StringProperty)stylesheet, window, arg_0));
        window.getScene().getRoot().layout();
    }

    private static DeviceType getTypeForWindow(Window window) {
        return DeviceType.getForWidth(window.getWidth());
    }

    private static String getCurrentResponsiveStylesheet(Window window) {
        return ResponsiveHandler.getTypeForWindow(window).getStylesheet();
    }

    private static void updateManagedPropertyForAllChildren(Window window) {
        for (Node n : Util.getAllNodesInWindow(window)) {
            ResponsiveHandler.updateManagedProperty(n, ResponsiveHandler.getTypeForWindow(window));
        }
    }

    private static void updateManagedProperty(Node n, DeviceType type) {
        if (!n.getProperties().containsKey((Object)PROP_MANAGED_STATE)) {
            n.getProperties().put((Object)PROP_MANAGED_STATE, (Object)n.isManaged());
        }
        n.managedProperty().removeListener(MANAGED_LISTENER);
        n.setManaged(n.isVisible() ? (Boolean)n.getProperties().get((Object)PROP_MANAGED_STATE) : false);
        n.managedProperty().addListener(MANAGED_LISTENER);
    }

    private static void updatePseudoClassesForAllChildren(Window window) {
        List<Node> nodes = Util.getAllNodesInWindow(window);
        for (Node node : nodes) {
            ResponsiveHandler.updatePseudoClasses(node, ResponsiveHandler.getTypeForWindow(window));
        }
    }

    private static void updatePseudoClasses(Node n, DeviceType type) {
        for (PseudoClass pseudoClass : type.getInactiveClasses()) {
            n.pseudoClassStateChanged(pseudoClass, false);
        }
        for (PseudoClass pseudoClass : type.getActiveClasses()) {
            n.pseudoClassStateChanged(pseudoClass, true);
        }
        deviceTypeProperty.set((Object)type);
    }

    private static void removeAllPseudoClasses(Node n) {
        for (PseudoClass pseudoClass : DeviceType.getAllClasses()) {
            n.pseudoClassStateChanged(pseudoClass, false);
        }
    }

    public static final void setOnDeviceTypeChanged(InvalidationListener LISTENER) {
        deviceTypeProperty.addListener(LISTENER);
    }

    public static final void setOnDeviceTypeChanged(ChangeListener<DeviceType> LISTENER) {
        deviceTypeProperty.addListener(LISTENER);
    }

    private static /* synthetic */ void lambda$addResponsiveToWindow$7(StringProperty stringProperty, Window window, Observable e) {
        stringProperty.setValue(ResponsiveHandler.getCurrentResponsiveStylesheet(window));
        ResponsiveHandler.updatePseudoClassesForAllChildren(window);
        ResponsiveHandler.updateManagedPropertyForAllChildren(window);
    }
}

