/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.stylemanager;

import com.guigarage.stylemanager.ApplicationStyle;
import com.guigarage.stylemanager.ApplicationStylePlugin;
import com.guigarage.stylemanager.OsInformationProvider;
import com.guigarage.stylemanager.StyleType;
import com.sun.javafx.css.StyleManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javafx.application.Application;

public class ApplicationStyleManager {
    private static ApplicationStyleManager instance;

    private ApplicationStyleManager() {
    }

    public static ApplicationStyleManager getInstance() {
        if (instance == null) {
            instance = new ApplicationStyleManager();
        }
        return instance;
    }

    public ApplicationStyle findSystemStyle() {
        for (ApplicationStyle stylesheet : this.loadAllStylesheet()) {
            StyleType type = stylesheet.getType();
            String osName = stylesheet.getPreferredOsName();
            if (osName == null || type == null || !type.equals((Object)StyleType.SYSTEM) || !OsInformationProvider.getInstance().isCurrentOs(osName)) continue;
            return stylesheet;
        }
        return null;
    }

    public ApplicationStyle findStyle(String uniqueName) {
        for (ApplicationStyle stylesheet : this.loadAllStylesheet()) {
            if (!uniqueName.equals(stylesheet.getUniqueName())) continue;
            return stylesheet;
        }
        return null;
    }

    public void styleApplication(Class<ApplicationStyle> styleClass) throws InstantiationException, IllegalAccessException {
        this.styleApplication(styleClass.newInstance());
    }

    public void styleApplication(String styleName) {
        this.styleApplication(this.findStyle(styleName));
    }

    public void styleApplication(ApplicationStyle stylesheet) {
        Application.setUserAgentStylesheet(null);
        boolean mainStylesheet = true;
        URL[] uRLArray = stylesheet.getCssUrls();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL cssUrl = uRLArray[n2];
            String fName = cssUrl.toExternalForm();
            if (mainStylesheet) {
                Application.setUserAgentStylesheet((String)fName);
                mainStylesheet = false;
            } else {
                StyleManager.getInstance().addUserAgentStylesheet(fName);
            }
            ++n2;
        }
        for (ApplicationStylePlugin plugin : this.loadPluginsForStylesheet(stylesheet)) {
            URL[] uRLArray2 = plugin.getCssUrls();
            int n3 = uRLArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                URL cssUrl = uRLArray2[n4];
                String fName = cssUrl.toExternalForm();
                StyleManager.getInstance().addUserAgentStylesheet(fName);
                ++n4;
            }
        }
    }

    private List<ApplicationStyle> loadAllStylesheet() {
        ServiceLoader<ApplicationStyle> loader = ServiceLoader.load(ApplicationStyle.class);
        Iterator<ApplicationStyle> iterator = loader.iterator();
        ArrayList<ApplicationStyle> ret = new ArrayList<ApplicationStyle>();
        while (iterator.hasNext()) {
            ret.add(iterator.next());
        }
        return ret;
    }

    private List<ApplicationStylePlugin> loadPluginsForStylesheet(ApplicationStyle stylesheet) {
        String stylesheetName = stylesheet.getUniqueName();
        ServiceLoader<ApplicationStylePlugin> loader = ServiceLoader.load(ApplicationStylePlugin.class);
        Iterator<ApplicationStylePlugin> iterator = loader.iterator();
        ArrayList<ApplicationStylePlugin> ret = new ArrayList<ApplicationStylePlugin>();
        while (iterator.hasNext()) {
            ApplicationStylePlugin plugin = iterator.next();
            String pluginName = plugin.getUniqueStyleName();
            if (pluginName == null || !pluginName.equals(stylesheetName)) continue;
            ret.add(plugin);
        }
        return ret;
    }
}

