/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.stylemanager;

public class OsInformationProvider {
    private static OsInformationProvider instance;
    private String osName = System.getProperty("os.name").toLowerCase();

    private OsInformationProvider() {
    }

    public static OsInformationProvider getInstance() {
        return instance;
    }

    public boolean isWindows() {
        return this.osName.indexOf("win") >= 0;
    }

    public boolean isMac() {
        return this.osName.indexOf("mac") >= 0;
    }

    public boolean isLinux() {
        return this.osName.indexOf("nux") >= 0;
    }

    public boolean isCurrentOs(String name) {
        if (name != null) {
            if (name.toLowerCase().startsWith("win") && this.isWindows()) {
                return true;
            }
            if (name.toLowerCase().startsWith("linux") && this.isLinux()) {
                return true;
            }
            if (name.toLowerCase().startsWith("mac") && this.isMac()) {
                return true;
            }
        }
        return false;
    }
}

